<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: graphs.php,v 1.3 2004/07/03 16:45:50 yeupou Exp $
#
#  Copyright 2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Attempt to replace HTML_graphs.php with someone more spartian, efficient
# and w3c compliant.

# It can accept db result directy or an array.
function graphs_build ($result, $field=0, $dbdirect=1) 
{
  if (!$result) 
    { 
      fb(_("No data to work on, no graph will be built"), 1);
      break;
    }
  
  $total = 0;

  if ($dbdirect) 
    {
      $content = array();
      for ($i=0; $i < db_numrows($result) ; $i++)
	{
	  $content[db_result($result, $i, 0)] = db_result($result, $i, 1);
	}
    }
  else
    {
      $content = $result;
    }

  # Get the total number of items
  $total = 0;
  while(list($k, $v)=each($content))
    {
      $total = ($total+$v);
    }
     
  # Print the stats, unless $total is nul
  if ($total) 
    {
      print "\n\n<table width=\"100%\">\n";
      reset($content);
      while(list($k, $v)=each($content))
	{
	  $percent = sprintf("%d", (($v / $total) * 100));
	  if ($field != "assigned_to")
	    { $title = $k; }
	  else 
	    { $title = utils_user_link($k); }
	  
	  print '<tr width="100%">'.
	    '<td width="16%" align="right" valign="center">'.$title.'</td>'.
	    '<td width="9%" align="center" valign="center">'.$percent._("%").'</td>'.
	    '<td width="75%" class="priora" align="left"><table class="priori" width="'.$percent.'%" cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td></tr></table></td>'.
	    '</tr>';
	}
      print "\n</table>\n\n";
    }
  else 
    {
      print '<p class="warn">Total of results is nul.</p>';
    }
}

?>
