<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: menu.php,v 1.111 2004/09/22 08:11:51 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#                          Yves Perrin <yves.perrin--at--cern.ch>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function menu_print_sidebar($params) 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_print_sidebar($params) ';
  global $HTML;
  
  print '
 <ul class="menu">
        <li class="menulogo">
';

  if ($GLOBALS['sys_logo_name']) 
    {
      print '          '.utils_link($GLOBALS['sys_home'], html_image($GLOBALS['sys_logo_name'],array('alt'=>sprintf(_("%s Homepage"), $GLOBALS['sys_name'])), 0));
    }
  else
    {
      print '          <br />'.utils_link($GLOBALS['sys_home'],sprintf(_("%s Homepage"), $GLOBALS['sys_name']));
    }

  print '
        </li><!-- end menulogo -->';  
  if (!user_isloggedin()) 
    {
      print menu_notloggedin();
    } 
  else
    {
      print menu_loggedin($params['title'], $params['toptab'], $params['group']);
    }
  print menu_search();
  # Site Admin menu added here
  if (user_is_super_user()) 
    {
      print menu_site_admin();
    }
  print menu_projects();
  print menu_help();
  print menu_documentation();
  # Valid HTML is now part of the site specific content
  utils_get_content("menu");
  
  print '
 </ul><!-- end menu -->
';

}


# Menu entry  for all admin tasks when logged as site administor
function menu_site_admin() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_site_admin() ';
    
  global $HTML;
  $HTML->menuhtml_top($GLOBALS['sys_name'].' '._("Administration")); 
  $HTML->menu_entry($GLOBALS['sys_home'].'admin/',_("Main page"));
  $HTML->menu_entry($GLOBALS['sys_home'].'admin/approve-pending.php',_("Pending projects"));
  $HTML->menu_entry($GLOBALS['sys_home'].'news/approve.php?group='.$GLOBALS['sys_unix_group_name'],_("Site news approval"));
  $HTML->menuhtml_bottom();

}

function menu_search() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_search() ';
  global $HTML;
  $HTML->menuhtml_top(_("Search"));
  print '       <li class="menusearch">';
  search_box();  
  print '       </li><!-- end menusearch -->';
  $HTML->menuhtml_bottom();
}


#deprecated - theme wrapper
function menuhtml_top($title) 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menuhtml_top() ';
  /*
		Use only for the top most menu
  */
  theme_menuhtml_top($title);
}

# Hosted projects
function menu_projects() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_projects() ';
  global $HTML;
  $HTML->menuhtml_top(_("Hosted Projects"));
  $HTML->menu_entry($GLOBALS['sys_home'].'register/',_("Register New Project"), user_isloggedin());
 $HTML->menu_entry($GLOBALS['sys_home'].'search/index.php?type_of_search=soft&amp;words=%%%',_("Full List"));
  $HTML->menuhtml_bottom();
}

# Savannah Help (dynamic help)
function menu_help() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_help() ';
  global $HTML;
  $HTML->menuhtml_top($GLOBALS['sys_name'].' '._("Help"));
  $HTML->menu_entry($GLOBALS['sys_home'].'support/?group='.$GLOBALS['sys_unix_group_name'],_("Get Support"));
  $HTML->menu_entry($GLOBALS['sys_home'].'people/',_("Contributor Wanted"));
  $HTML->menuhtml_bottom();
}

# Savannah Documentation (static help)
function menu_documentation() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_documentation() ';
  GLOBAL $HTML;
  $HTML->menuhtml_top($GLOBALS['sys_name'].' '._("Documentation"));
  $HTML->menu_entry($GLOBALS['sys_home'].'faq/?group='.$GLOBALS['sys_unix_group_name'],_("User Docs (FAQ)"));
  if (user_can_be_super_user()) 
    {
      $HTML->menu_entry($GLOBALS['sys_home'].'docs/admin.php',_("Server Admin Docs"));
      if ($GLOBALS['sys_localdoc_file'])
	{
	  $HTML->menu_entry($GLOBALS['sys_home'].'docs/admin.php?local=1',_("Local Server Admin Docs"));
	}
    }

  if ($GLOBALS['sys_mrtg_dir'] || $GLOBALS['sys_webalizer_dir']) 
    {
      $HTML->menu_entry($GLOBALS['sys_home'].'docs/webalizer.php',_("Statistics"));
    }
  $HTML->menu_entry($GLOBALS['sys_home'].'contact.php',_("Contact Us"));
  $HTML->menuhtml_bottom();
}

function menu_loggedin($page_title, $page_toptab=0, $page_group=0) 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_loggedin($page_title) ';
  global $HTML;
  /*
		Show links appropriate for someone logged in, like account maintenance, etc
  */
  if (!user_is_super_user()) 
    {
      $HTML->menuhtml_top(sprintf(_("Logged in as %s"), user_getname()));
    }
  else
    {
      $HTML->menuhtml_top('<font class="warn">'.sprintf(_("%s logged in as superuser"), user_getname()).'</font>');
    }
  if (user_can_be_super_user() && !user_is_super_user()) 
    {
      $HTML->menu_entry($GLOBALS['sys_home'].'account/su.php?action=login&amp;uri='.urlencode($GLOBALS['REQUEST_URI']), _("Become Superuser"));      
    }
  $HTML->menu_entry($GLOBALS['sys_home'].'my/',_("My Items"));
  $HTML->menu_entry($GLOBALS['sys_home'].'my/groups.php',_("My Groups"));
  $HTML->menu_entry($GLOBALS['sys_home'].'account/',_("My Account Conf"));
  if (!$GLOBALS['HTTP_POST_VARS']) 
    {
      $bookmark_title = "";
      if ($page_toptab) 
	{ $bookmark_title .= urlencode(title_toptab($page_toptab, $page_group)); }
      if ($page_title) 
	{ $bookmark_title .= urlencode(_(": ").$page_title); }


      $HTML->menu_entry($GLOBALS['sys_home'].'my/bookmark_add.php?bookmark_url='.urlencode($GLOBALS['REQUEST_URI']).'&amp;bookmark_title='.$bookmark_title,_("Bookmark This Page"));
    }

 if (user_is_super_user()) 
    {
      $HTML->menu_entry($GLOBALS['sys_home'].'account/su.php?action=logout&amp;uri='.urlencode($GLOBALS['REQUEST_URI']), _("Logout Superuser"));      
    }
  $HTML->menu_entry($GLOBALS['sys_home'].'account/logout.php',_("Logout"));
  $HTML->menuhtml_bottom();
}

function menu_notloggedin() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':menu_notloggedin() ';
  global $HTML;
  $HTML->menuhtml_top(_("Login Status:"));
  print '
        <li class="menuitem"><font class="error">'._("Not Logged In").'</font></li>';
  $HTML->menu_entry($GLOBALS['sys_home'].'faq/?question='.urlencode("1._Why_log_in.txt"),_("Why Log In?"));
  $HTML->menu_entry($GLOBALS['sys_https_url'].$GLOBALS['sys_home'].'account/login.php?uri='.urlencode($GLOBALS['REQUEST_URI']),_("Login via SSL"));
  $HTML->menu_entry($GLOBALS['sys_https_url'].$GLOBALS['sys_home'].'account/register.php',_("New User via SSL"));
  $HTML->menuhtml_bottom();
}

?>
