<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: general.php,v 1.7 2004/09/22 08:11:51 yeupou Exp $
#
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function my_hide_url ($svc, $db_item_id, $item_id, $count, $hide) 
{
/*
  Function that generates hide/show urls to expand/collapse
  sections of the personal page

Input:
  $svc : artifact
  $db_item_id : the item (group, forum, task sub-project,...) from the
     database that we are curently processing and about to display
  $item_id : the item_id as given in the URL and on which the show/hide switch
     is going to apply.
  $hide = hide param as given in the script URL (-1 means no param was given)

Output:
  $hide_url: URL to use in the page to switch from hide to show or vice versa
  $count_diff: difference between the number of items in the list between now and
     the previous last time the section was open (can be negative if items were removed)
  $hide_flag: true if the section must be hidden, false otherwise

*/

  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_hide_url ($svc, $db_item_id, $item_id, $count, $hide) ';
  global $PHP_SELF;

  $pref_name = 'my_hide_'.$svc.$db_item_id;
  $old_pref_value = user_get_preference($pref_name);
  list($old_hide,$old_count) = explode('|', $old_pref_value);
  
  # Make sure they are both 0 if never set before
  if ($old_count == false) { $old_count = 0; }
  if ($old_hide == false) { $old_hide = 0; }

  if ($item_id == $db_item_id) 
    {
      if (isset($hide)) 
	{
	  $pref_value = "$hide|$count";
	} 
      else 
	{
	  $pref_value = "$old_hide|$count";
	  $hide = $old_hide;
	}
    } 
  else
    {
      if ($old_hide) 
	{
	  # if items are hidden keep the old count and keep pref as is
	  $pref_value = $old_pref_value;
	} 
      else 
	{
	  # only update the item count if the items are visible
	  # if they are hidden keep reporting the old count
	  $pref_value = "$old_hide|$count";
	}
      $hide = $old_hide;
    }
    
  # Update pref value if needed
  if ($old_pref_value != $pref_value) 
    {
      user_set_preference($pref_name, $pref_value);
    }
    
  if ($hide) 
    {
      $hide_url= '&nbsp;&nbsp;<a href="'.$PHP_SELF.'?hide_'.$svc.'=0&amp;hide_group_id='.$db_item_id.'"><img src="'.$GLOBALS['sys_home'].'images/'. SV_THEME.'.theme/next.png" align="middle" border="0" alt="Collapse" /></a>&nbsp;';
      $hide_now = true;
    } 
  else 
    {		
      $hide_url= '&nbsp;&nbsp;<a href="'.$PHP_SELF.'?hide_'.$svc.'=1&amp;hide_group_id='.$db_item_id.'"><img src="'.$GLOBALS['sys_home'].'images/'. SV_THEME.'.theme/down.png" align="middle" border="0" alt="Expand" /></a>&nbsp;';
      $hide_now = false;
    }
    
  return array($hide_now, $count-$old_count, $hide_url);
}

function my_format_as_flag($assigned_to, $submitted_by) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_format_as_flag($assigned_to, $submitted_by) ';
  $AS_flag = '';
  if ($assigned_to == user_getid()) 
    {
      $AS_flag = 'A';
    }
  if ($submitted_by == user_getid()) 
    {
      $AS_flag .= 'S';
    }
  if ($AS_flag) { $AS_flag = '[<b>'.$AS_flag.'</b>]'; }
  
  return $AS_flag;
}

function my_item_count($total, $new) 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_item_count($total, $new) ';
  $ret = '(';
  if ($total > 1) 
    { $ret .= sprintf(_("%s items"), $total); }
  else 
    { $ret .= sprintf(_("%s item"), $total); }
  $ret .= ($new ? ", <b>".sprintf(_("%s new"), $new)."</b>)" : ')');
  return $ret;
}

function my_artifact_items ($artifact)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':my_artifact_items ($artifact)';
  global $hide_now, $lessthanzero;
  
  $sql='SELECT group_id,COUNT(bug_id) '.
     'FROM '.$artifact.' '.
     'WHERE status_id <> 3 '.
     'AND (assigned_to='.user_getid().
     ' OR submitted_by='.user_getid().') GROUP BY group_id ORDER BY group_id ASC LIMIT 100';
  
  $result=db_query($sql);
  $rows=db_numrows($result);
  if (!$result || $rows < 1) 
    {
      print _("No Open Item is assigned to me or was submitted by me");
    } 
  else 
    {
      for ($j=0; $j<$rows; $j++) 
	{
		
	  $group_id = db_result($result,$j,'group_id');
		
	  $sql2='SELECT bug_id,priority,assigned_to,submitted_by,date AS open_date,summary '.
	     'FROM '.$artifact.' '.
	     'WHERE group_id='.$group_id.' AND status_id <> 3 '.
	     'AND (assigned_to='.user_getid().
	     ' OR submitted_by='.user_getid().') LIMIT 100';

	  $result2 = db_query($sql2);
	  $rows2 = db_numrows($result2);


	  list($hide_now,$count_diff,$hide_url) = 
	    my_hide_url($artifact,$group_id,$GLOBALS['hide_group_id'],$rows2,$GLOBALS['hide_'.$artifact]);
	  

	   $html_hdr = ($j ? '<div class="boxitem">' : '').
	     $hide_url.'<a href="'.$GLOBALS['sys_home'].$artifact.'/?group_id='.$group_id.'"><b>'.
	     group_getname($group_id).'</b></a>&nbsp;&nbsp;&nbsp;&nbsp;';
	  $html = '';
	  $count_new = max(0, $count_diff);
	  for ($i=0; $i<$rows2; $i++) 
	    {
	      if (!$hide_now) 
		{
		  # Form the 'Submitted by/Assigned to flag' for marking
		  $AS_flag = my_format_as_flag(db_result($result2,$i,'assigned_to'), db_result($result2,$i,'submitted_by'));
		  
		  $html .= '<div class="'.get_priority_color(db_result($result2,$i,'priority')).
		    '">';
		  $html .= '<a href="'.$GLOBALS['sys_home'].$artifact.'/?func=detailitem&amp;item_id='.db_result($result2,$i,'bug_id').'">#'.db_result($result2,$i,'bug_id').'</a>';
		  $html .= _(": ").'&nbsp;';
		  $html .= '<a href="'.$GLOBALS['sys_home'].$artifact.'/?func=detailitem&amp;item_id='.db_result($result2,$i,'bug_id').'">'.stripslashes(db_result($result2,$i,'summary')).'</a>';
		  $html .= '&nbsp;'.$AS_flag;

		  $html .= '</div>';
			  
		}
              # used to know if we need to add a boxitem or not
	      $lessthanzero = 1;
	    }
	  
	  $html_hdr .= my_item_count($rows2,$count_new).'</div><!-- end boxitem -->';
	  print $html_hdr.$html;
	}
  
    }
}

?>
