<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: format.php,v 1.12 2004/09/23 16:31:05 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#                          Yves Perrin <yves.perrin--at--cern.ch>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function format_item_details ($item_id, $group_id, $ascii=false)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':format_item_details ($item_id, $group_id, $ascii=false)';

  /*
      Format the details rows from trackers_history
  */
  global $sys_datefmt;
  $result=trackers_data_get_followups ($item_id);
  $rows=db_numrows($result);

  # No followup comment -> return now
  if ($rows <= 0)
    {
      if ($ascii)
	$out = "";
      else
	$out = '<font class="warn">'._("No Followups Have Been Posted").'</font>';
      return $out;
    }

  # Header first
  if ($ascii)
    {
      $out .= _("Follow-up Comments")."\n------------------\n";
    }
  else
    {
      $title_arr=array();
      $title_arr[]=_("Comment");
      $title_arr[]=_("Posted By");
      $title_arr[]=_("Date");
	
      $out .= html_build_list_table_top ($title_arr);
    }
    
  # Loop throuh the follow-up comments and format them
  for ($i=0; $i < $rows; $i++)
    {
	
      $comment_type = db_result($result, $i, 'comment_type');
      if ($comment_type == 'None') 
	{ $comment_type = ''; }
      else
	{ $comment_type = '['.$comment_type.']'; }
	
      if ($ascii)
	{
	  $fmt = "\n\n-------------------------------------------------------\n".
	     "Date: %-30sBy: %s\n";
	  if ($comment_type)
	    { $fmt .= "%s\n%s"; }
	  else
	    { $fmt .= "%s%s"; }
	}
      else
	{
	  $fmt = "\n".'<tr class="%s"><td>%s%s</td>'.
	     '<td valign="top" align="center">%s</td><td valign="top" align="center">%s</td></tr>';
	}
	
      # I wish we had sprintf argument swapping in PHP3 but
      # we don't so do it the ugly way...
      if ($ascii)
	{
	  $out .= sprintf($fmt,
			  format_date($sys_datefmt,db_result($result, $i, 'date')),
			  db_result($result, $i, 'realname')." <".db_result($result, $i, 'user_name').">",
			  $comment_type,
			  utils_unconvert_htmlspecialchars(db_result($result, $i, 'old_value'))
			  );
	}
      else
	{
	  if ($comment_type)
	    {
	      # put the comment type in bold
	      $comment_type = '<font class="bold">'.$comment_type.'</font><br />';
	    }
	  $out .= sprintf($fmt,
			  utils_get_alt_row_color($i),
			  $comment_type,
			  '<p>'.utils_make_links(nl2br(db_result($result, $i, 'old_value')),$group_id).'<p>',
			  utils_user_link(db_result($result, $i, 'user_name'),db_result($result, $i, 'realname')),
			  format_date($sys_datefmt,db_result($result, $i, 'date')));
;
	}
    }

  # final touch...
  $out .= ($ascii ? "\n\n\n" : "</table>");

  return($out);
}



function format_item_changes ($changes)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':format_item_changes ($changes)';

  global $sys_datefmt;

  reset($changes);
  $fmt = "%20s | %-25s | %s\n";

  if (user_isloggedin())
    {
      $user_id = user_getid();
      $out_hdr = "Changes by: \n\t\t".user_getrealname($user_id).' <'.user_getemail($user_id).">\n";
      $out_hdr .= "'Date: \n\t\t".format_date($sys_datefmt,time()).' ('.user_get_timezone().')';
    }
  else
    {
      $out_hdr = "Changes by: Anonymous user\nDate:  \n\t\t".format_date($sys_datefmt,time());
    }

  #Process special cases first: follow-up comment
  if ($changes['details'])
    {
      $out_com = "\n\n------------------ Additional Follow-up Comments ----------------------------\n";
      if ($changes['details']['type'] != 'None')
	{
	  $out_com .= '['.$changes['details']['type']."]\n";
	}
      $out_com .= utils_unconvert_htmlspecialchars($changes['details']['add']);
      unset($changes['details']);
    }

  #Process special cases first: bug file attachment
  if ($changes['attach'])
    {
      $out_att = "\n\n------------------ Additional Item Attachment  ----------------------------\n";
      $out_att .= sprintf("File name: %-30s Size:%d KB\n",$changes['attach']['name'],
			  intval($changes['attach']['size']/1024) );
      $out_att .= $changes['attach']['description']."\n".$changes['attach']['href'];
      unset($changes['attach']);
    }

  # All the rest of the fields now
  reset($changes);
  while ( list($field,$h) = each($changes))
    {

      # If both removed and added items are empty skip - Sanity check
      if (!$h['del'] && !$h['add'])
	{ continue; }

      $label = trackers_data_get_label($field);
      if (!$label)
	{ $label = $field; }
      $out .= sprintf($fmt, $label, $h['del'],$h['add']);
    }
  if ($out)
    {
      $out = "\n\n".sprintf($fmt,'What    ','Removed','Added').
	 "---------------------------------------------------------------------------\n".$out;
    }

  return($out_hdr.$out.$out_com.$out_att);

}


function format_item_attached_files ($item_id,$group_id,$ascii=false)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':format_item_attached_files ($item_id,$group_id,$ascii=false)';

  global $sys_datefmt;

  /*
          show the files attached to this bug
  */

  $result=trackers_data_get_attached_files($item_id);
  $rows=db_numrows($result);

  # No file attached -> return now
  if ($rows <= 0)
    {
      if ($ascii)
	$out = "";
      else
	$out = '<font class="warn">'._("No files currently attached").'</font>';
      return $out;
    }

  # Header first
  if ($ascii)
    {
      $out .= _("File Attachments")."\n-------------------";
    }
  else
    {	
	
      $title_arr=array();
      $title_arr[]=_("Name");
      $title_arr[]=_("Description");
      $title_arr[]=_("Size");
      $title_arr[]=_("Added By");
      $title_arr[]=_("Date");
      if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2'))
	{
	  $title_arr[]='Delete?';
	}

      $out .= html_build_list_table_top ($title_arr);
    }

  # Determine what the print out format is based on output type (Ascii, HTML
  if ($ascii)
    {
      $fmt = "\n\n-------------------------------------------------------\n".
	 "Date: %s  Name: %s  Size: %s   By: %s\n%s\n%s";
    }
  else
    {
      $fmt = "\n".'<TR class="%s"><td>%s</td><td>%s</td><td align="center">%s</td><td align="center">%s</td><td align="center">%s</td>'.
	 (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2') ? '<td align="center">%s</td>':'').'</tr>';
    }

  # Loop throuh the attached files and format them
  for ($i=0; $i < $rows; $i++)
    {

      $item_file_id = db_result($result, $i, 'bug_file_id');
      $href = $GLOBALS['sys_home'].ARTIFACT."/download.php?item_id=$item_id&amp;item_file_id=$item_file_id";

      if ($ascii)
	{
	  $out .= sprintf($fmt,
			  format_date($sys_datefmt,db_result($result, $i, 'date')),
			  db_result($result, $i, 'filename'),
			  utils_filesize(0, intval(db_result($result, $i, 'filesize'))),
			  db_result($result, $i, 'user_name'),
			  db_result($result, $i, 'description'),
			  'http://'.$GLOBALS['sys_default_domain'].utils_unconvert_htmlspecialchars($href));
	}
      else
	{
	  $out .= sprintf($fmt,
			  utils_get_alt_row_color($i),
			  "<a href=\"$href\">". db_result($result, $i, 'filename').'</a>',
			  db_result($result, $i, 'description'),
			  utils_filesize(0, intval(db_result($result, $i, 'filesize'))),
			  utils_user_link(db_result($result, $i, 'user_name')),
			  format_date($sys_datefmt,db_result($result, $i, 'date')),
			  "<a href=\"$PHP_SELF?func=delete_file&amp;item_id=$item_id&amp;item_file_id=$item_file_id\" ".
			  '" onClick="return confirm(\''._("Delete this attachment?").'\')">'.
			  '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Delete").'" /></a>');
	}
    }

  # final touch...
  $out .= ($ascii ? "\n" : "</table>");

  return($out);

}



function format_item_cc_list ($item_id,$group_id, $ascii=false)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':format_item_cc_list ($item_id,$group_id, $ascii=false)';

  global $sys_datefmt;

  /*
          show the files attached to this bug
  */

  $result=trackers_data_get_cc_list($item_id);
  $rows=db_numrows($result);

  # No file attached -> return now
  if ($rows <= 0)
    {
      if ($ascii)
	{
	  $out .= ""; 
	}
      else
	{
	  $out = '<font class="warn">'._("CC list is empty").'</font>';
	}
      return $out;
    }

  # Header first an determine what the print out format is
  # based on output type (Ascii, HTML)
  if ($ascii)
    {
      $out .= "CC List\n-------\n\n";
      $fmt = "%-35s | %s\n";
      $out .= sprintf($fmt, 'CC Address', 'Comment');
      $out .= "------------------------------------+-----------------------------\n";
    }
  else
    {	

      $title_arr=array();
      $title_arr[]=_('CC Mail Address');
      $title_arr[]=_('Comment');
      $title_arr[]=_('Added by');
      $title_arr[]=_('Date');
      $title_arr[]=_('Delete?');
      $out .= html_build_list_table_top ($title_arr);
      $fmt = "\n".'<tr class="%s"><td>%s</td><td>%s</td><td align="center">%s</td>'.
	 '<td align="center">%s</td><td align="center">%s</td></tr>';
    }

  # Loop through the cc and format them
  for ($i=0; $i < $rows; $i++)
    {

      $email = utils_antispam_email(db_result($result, $i, 'email'));
      $item_cc_id = db_result($result, $i, 'bug_cc_id');

      # If the CC is a user point to its user page.
      # Do not build mailto, we do not need to help spammers.
      $res_username = user_get_result_set_from_unix($email);
      if ($res_username && (db_numrows($res_username) == 1))
	{ $href_cc = utils_user_link($email); }
      else
	{ $href_cc = $email; }

      if ($ascii)
	{
	  $out .= sprintf($fmt, $email, db_result($result, $i, 'comment'));
	}
      else
	{

	  # show CC delete icon if one of the condition is met:
	  # a) current user is a bug admin
	  # b) then CC name is the current user 
	  # c) the CC email address matches the one of the current user
	  # d) the current user is the person who added a gieven name in CC list
	  if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2') ||
	       (user_getname(user_getid()) == $email) ||  
	       (user_getemail(user_getid()) == $email) ||
	       (user_getname(user_getid()) == db_result($result, $i, 'user_name') ))
	    {
	      $html_delete = "<a href=\"$PHP_SELF?func=delete_cc&amp;item_id=$item_id&amp;item_cc_id=$item_cc_id\" ".
		 '" onClick="return confirm(\''._("Delete this CC address?").'\')">'.
		 '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Delete").'" /></a>';
	    }
	  else
	    {
	      $html_delete = '-';
	    }

	  $out .= sprintf($fmt,
			  utils_get_alt_row_color($i),
			  $href_cc,
			  db_result($result, $i, 'comment'),
			  utils_user_link(db_result($result, $i, 'user_name')),
			  format_date($sys_datefmt,db_result($result, $i, 'date')),
			  $html_delete);
	}
    }

  # final touch...
  $out .= ($ascii ? "\n" : "</table>");

  return($out);

}


?>
