<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.58 2004/09/22 08:11:51 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require '../include/pre.php';
require_directory("trackers");

# Checking for variables declared in the request.

# $func
if ($_POST['func'])
   { 
   $func = $_POST['func']; 
   }
elseif ($_GET['func'])
   { 
   $func = $_GET['func']; 
   }
# $bookmark_id 
if ($_POST['bookmark_id'])
   { 
   $bookmark_id = $_POST['bookmark_id']; 
   }
elseif ($_GET['bookmark_id'])
   { 
   $bookmark_id = $_GET['bookmark_id']; 
   }
# $feedback 
if ($_POST['feedback'])
   { 
   $feedback = $_POST['feedback']; 
   }
elseif ($_GET['feedback'])
   { 
   $feedback = $_GET['feedback']; 
   }     
    
if (user_isloggedin())
{

  # Some action to be done ?
  if ($func)
    {
      if ($func == "delwatchee")
	{
	  # Stop watching another user
	  $result = trackers_data_delete_watchees(user_getid(),$watchee_id,$group_id);
	  if (!$result)
	    {
	      fb(_("Unable to remove user from the watched users list, probably a broken URL"));
	    }

	}

      if ($func == "addwatchee")
	{
	  # Stop watching another user
	  $result = trackers_data_add_watchees(user_getid(),$watchee_id,$group_id);
	  if (!$result)
	    {
	      fb(_("Unable to add user in the watched users list, probably a broken URL"));
	    }

	}

      if ($func == "delbookmark")
	{
	  # Remove a bookmark
	  if ($bookmark_id)
	    {
	      bookmark_delete($bookmark_id);
	    }
	}

    }

  # Make sure this page is not cached because
  # it uses the exact same URL for all user's
  # personal page
  header("Cache-Control: no-cache, must-revalidate"); # for HTTP 1.1
  header("Pragma: no-cache");  # for HTTP 1.0

  site_user_header(array('toptab'=>'my'));
  # we get site-specific content
  utils_get_content("my/index");
  print "<br /><br />\n\n";

  if ($feedback)
    {
      print $feedback;
    }

 ################ RIGHT PART ############################

  print html_splitpage(1);

  # Bookmarks
  print $HTML->box1_top(_("My Bookmarks"));

  $result = db_query("SELECT bookmark_url, bookmark_title, bookmark_id from user_bookmarks where ".
		     "user_id='". user_getid() ."' ORDER BY bookmark_title");
  $rows=db_numrows($result);
  if (!$result || $rows < 1)
    {
      print _("I currently do not have any bookmarks saved");
      print db_error();
    }
  else
    {

      print '<table>';
      for ($i=0; $i<$rows; $i++)
	{
	  print '<tr class="'. utils_get_alt_row_color($i) .'"><td width="99%">';
	  print '
                                           <b><a href="'. db_result($result,$i,'bookmark_url') .'">'.
	    db_result($result,$i,'bookmark_title') .'</a></b> '.
	    '<a href="'.$GLOBALS['sys_home'].'my/bookmark_edit.php?bookmark_id='. db_result($result,$i,'bookmark_id') .'">[Edit]</a></td>'.
	    '<td><a href="'.$PHP_SELF.'?func=delbookmark&amp;bookmark_id='. db_result($result,$i,'bookmark_id') .
	    '" onClick="return confirm(\''._("Delete this bookmark?").'\')">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Delete this bookmark?").'" /></a></td></tr>';
	}
      print '</table>';
    }
  print $HTML->box1_bottom();
  print '<br /><br />';



  # Forums that are actively monitored
  print $HTML->box1_top(_("Monitored Forums"));

  $sql="SELECT groups.group_id, groups.group_name ".
     "FROM groups,forum_group_list,forum_monitored_forums ".
     "WHERE groups.group_id=forum_group_list.group_id ".
     "AND forum_group_list.group_forum_id=forum_monitored_forums.forum_id ".
     "AND forum_monitored_forums.user_id='".user_getid()."' GROUP BY group_id ORDER BY group_id ASC LIMIT 100";

  $result=db_query($sql);
  $rows=db_numrows($result);
  if (!$result || $rows < 1)
    {
      print '<p>'._("I am not monitoring any forums.").'</p>';
      print '<p>'._("If I monitor forums, I will be sent new posts in the form of an email, with a link to the new message.");
      print '<p>'._("I can monitor forums by clicking 'Monitor Forum' in any given discussion forum.");
      print '<br />&nbsp;';
      print db_error();
    }
  else
    {

      for ($j=0; $j<$rows; $j++)
	{

	  $group_id = db_result($result,$j,'group_id');

	  $sql2="SELECT forum_group_list.group_forum_id,forum_group_list.forum_name ".
	     "FROM groups,forum_group_list,forum_monitored_forums ".
	     "WHERE groups.group_id=forum_group_list.group_id ".
	     "AND groups.group_id=$group_id ".
	     "AND forum_group_list.group_forum_id=forum_monitored_forums.forum_id ".
	     "AND forum_monitored_forums.user_id='".user_getid()."' LIMIT 100";

	  $result2 = db_query($sql2);
	  $rows2 = db_numrows($result2);

	  list($hide_now,$count_diff,$hide_url) =
	    my_hide_url('forum',$group_id,$hide_item_id,$rows2,$hide_forum);

	  $html_hdr = ($j ? '<td colspan="2">' : '').
	     $hide_url.'<A HREF="'.$GLOBALS['sys_home'].'forum/?group_id='.$group_id.'"><B>'.
	     db_result($result,$j,'group_name').'</B></A>&nbsp;&nbsp;&nbsp;&nbsp;';

	  $html = '';
	  $count_new = max(0, $count_diff);
	  for ($i=0; $i<$rows2; $i++)
	    {

	      if (!$hide_now)
		{
		  $group_forum_id = db_result($result2,$i,'group_forum_id');
		  $html .= '
			<tr class="'. utils_get_alt_row_color($i) .'"><td width="99%">'.
		     '&nbsp;&nbsp;&nbsp;-&nbsp;<a href="'.$GLOBALS['sys_home'].'forum/forum.php?forum_id='.$group_forum_id.'">'.
		     stripslashes(db_result($result2,$i,'forum_name')).'</a></td>'.
		     '<td align="middle"><a href="'.$GLOBALS['sys_home'].'forum/monitor.php?forum_id='.$group_forum_id.
		     '" onClick="return confirm(\''._("Stop monitoring this Forum?").'\')">'.
		     '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" '.
		     'border="0" alt="'._("Stop monitoring this Forum?").'" /></a></td></tr>';
		}
	    }

	  $html_hdr .= my_item_count($rows2,$count_new).'</td></tr>';
	  print $html_hdr.$html;
	}

      print '<TR><TD COLSPAN="2">&nbsp;</TD></TR>';
    }
  print $HTML->box1_bottom();
  print '<br /><br />';

  # Watching other users.

  print $HTML->box1_top(_("Watched Partners"));

  $result = trackers_data_get_watchees(user_getid());
  $rows=db_numrows($result);

  if (!$result || $rows < 1)
    {
      print '<p>'._("I am not watching any partners.").'</p>';
      print '<p>'._("Watching a partner (receiving a copy of all the notification sent to him) permits to be his backup when he is away from the office, or to do QA to all his/her activities on a project.");
      print '</p><p>'._("To watch someone, click 'Watch Partner' in any project memberlist page (membership to that project is required, indeed).");
      print '<br />&nbsp;';
      print db_error();
    }
  else
    {

      print '<table>';
      for ($i=0; $i<$rows; $i++)
	{
	  print '<tr class="'.utils_get_alt_row_color($i).'"><td width="99%"><font class="bold">'.
	    utils_user_link(user_getname(db_result($result, $i, 'watchee_id')), user_getrealname(db_result($result, $i, 'watchee_id'))).
	    '</font> <font class="smaller">['.group_getname(db_result($result, $i, 'group_id')).']'.
	    '</font>';

	  print '</td>'.
	    '<td><a href="'.$PHPSELF.'?func=delwatchee&amp;group_id='.db_result($result,$i,'group_id').'&amp;watchee_id='.db_result($result, $i, 'watchee_id').
	    '" onClick="return confirm(\''._("Stop watching this user?").'\')">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Stop watching this user?").'" /></a></td></tr>';
	}
      print '</table>';

    }

  $result = trackers_data_get_watchers(user_getid());
  $arr_watchers = array();
  while ($row_watcher = db_fetch_array($result))
    {
      $watchers .= utils_user_link(user_getname($row_watcher['user_id']), user_getrealname($row_watcher['user_id'])).'</font> <font class="smaller">['.group_getname($row_watcher['group_id']).']</font>, ';
    }

  if ($watchers)
    {
      $watchers = substr($watchers,0,-2); # remove extra comma at the end
      $watchers .= ".";

      print '<p>';
      printf (_("My own notifications are currently watched by: %s"),$watchers);
      print '</p>';
    }
  else
    {
      print '<p>'._("Nobody is currently watching my own notifications.").'</p>';
    }

  print $HTML->box1_bottom();


 ################ LEFT PART ############################

  print html_splitpage(2);

  global $lessthanzero;
  $lessthanzero = 0; 

  # Tasks assigned to me
  print $HTML->box_top(_("My Tasks"));
  my_artifact_items("task");
  print $HTML->box_bottom($lessthanzero);
  print '<br /><br />'."\n";
  $lessthanzero = 0; 

  # SRs assigned to or submitted by me
  print $HTML->box_top(_("My Support Requests"));
  my_artifact_items("support");
  print $HTML->box_bottom($lessthanzero);
  print '<br /><br />'."\n";
  $lessthanzero = 0; 

  # Bugs assigned to or submitted by me
  print $HTML->box_top(_("My Bugs"));
  my_artifact_items("bugs");
  print $HTML->box_bottom($lessthanzero);
  print '<br /><br />'."\n";
  $lessthanzero = 0; 

  # Patch assigned to me
  print $HTML->box_top(_("My Patches"));
  my_artifact_items("patch");
  print $HTML->box_bottom($lessthanzero);
  print '<br /><br />'."\n";
  $lessthanzero = 0; 


  print html_splitpage(3);

  # End

  print "\n\n".show_priority_colors_key();


  $HTML->footer(array());

}
else
{

  exit_not_logged_in();

}

?>
