#!/usr/bin/env perl
#
# $Id: sv_po_stats.pl,v 1.1 2004/03/05 18:16:07 yeupou Exp $
#
# Program to show some statistics about .po files in the same directory
#
# Copyright (c) 2004 Tobias Toedter <t.toedter@gmx.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


use strict;


# set to "slurp" mode - read whole file in, not line by line
$/ = "";

print "The numbers are: total, fuzzy, untranslated.\n\n";

while (<*.po>) {
	&show_stats($_);
}


sub show_stats
{
	my($file) = @_;
	my $total = 0;
	my $fuzzy = 0;
	my $untranslated = 0;
	my $complete = 0;

	open INPUT, "$file";
	while (<INPUT>) {
		if (/\#, fuzzy.*\nmsgid/) {
			$fuzzy++;
		}
		if (/\nmsgstr \"\"\n\n/) {
			$untranslated++;
		}
		if (/\nmsgid \"/) {	#"
			$total++;
		}
	}
	close INPUT;

	# substract one because of the header info
	$total--;

	printf "%8s: ", $file;
	printf "%4d - ", $total;
	printf "%4d (%4.1f%%) - ", $fuzzy, 100*$fuzzy/$total;
	printf "%4d (%4.1f%%)  ->  ", $untranslated, 100*$untranslated/$total;
	$complete = $total - $fuzzy - $untranslated;
	printf "%5.1f%% completed.\n", 100*$complete/$total;
}
