#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_aliases.pl,v 1.12 2005/06/23 14:03:32 yeupou Exp $
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001
#               Mathieu Roy <yeupou@gnu.org>, 2003
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use Getopt::Long;
use Savane;
use File::Copy;

# Imports (needed for strict)
our $sys_mail_list;
our $sys_mail_aliases;
our $sys_cron_mail;

# Preconfigure
my $tmpdir = "/tmp/sv-aliases";
my $sysemails =  "$sys_mail_list";
my $sysaliases = "$sys_mail_aliases";
my $debug = 0;
my $cron;
my $getopt;
my $help;

eval {
    $getopt = GetOptions("debug" => \$debug,
			 "cron" => \$cron,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
Usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]

Include a list of Savannah users in /etc/email-addresses and
/etc/aliases.

      --help                   Show this help and exit
      --cron                   Option to set when including this script
                               in a crontab
      --debug		       Debug mode: do everything apart from 
                               overwriting system files
      --help		       Print this help

Author: loic\@gnu.org
EOF
 exit(1);
}

# Test if we should run, according to conffile
exit if ($cron && ! $sys_cron_mail);

###  /etc/email-addresses

# Avoid race conditions with tmpfile
system("/bin/rm", "-rf", $tmpdir);
mkdir($tmpdir, 0700)
    or die "Unable to create $tmpdir safely. Exiting";
print "$tmpdir created\n" if $debug;

# Create a temporary file
open(TEMP, "> $tmpdir/temp")
    or die "cannot open $tmpdir/temp for writing : $!";

# Extract database content, store it in the temporary file
# We do extracting database content in order to reduce risk of missing
# entries that would have been added while the script is running
# (if we that risk starts being unacceptable, we'll have to considere locking
# files in /etc)
print TEMP "# Savannah include start\n";
print TEMP "################################################################\n";
print TEMP "#  Please DO NOT MODIFY the section in between                 #\n";
print TEMP "#  'Savannah include start' and 'Savannah include end'.        #\n";
print TEMP "#  It is generated automatically by sv_aliases                 #\n";
print TEMP "###############################################################\n";
PrintAliasesList("TEMP");
print TEMP "# Savannah include end\n";
print "$tmpdir/temp written\n" if $debug;
close(TEMP);
open(TEMP, "< $tmpdir/temp");


# Extract current system addresses not managed by Savane, put them in 
# another temporary file
if ($sysemails || $debug) {
    open(OUT, "> $tmpdir/email-addresses")
	or die "cannot open $tmpdir/email-addresses for writing : $!";
        
    open(IN, "< $sysemails");
    while(<IN>) {
	next if(/^\# Savannah include start/ .. /^\# Savannah include end/);
	print OUT $_;
    }
    close(IN); 

    seek(TEMP, 0, 0);
    while(<TEMP>) {
	print OUT $_;
    }

    close(OUT);    
    print "$tmpdir/email-addresses written\n" if $debug;

    # Overwrite current system emails with the new file
    unless ($debug) {
	move("$tmpdir/email-addresses", $sysemails)
	    or die "Unable to overwrite $sysemails with $tmpdir/email-addresses, exiting";
    } else {
	print "Would do \"/bin/mv $tmpdir/email-addresses $sysemails\"\n";
    }
}

###  /etc/aliases
# Extract current system addresses not managed by Savane, put them in 
# another temporary file

if ($sysaliases || $debug) {
    open(OUT, "> $tmpdir/aliases")
	or die "cannot open $tmpdir/aliases for writing : $!";
        
    open(IN, "< $sysaliases");
    while(<IN>) {
	next if(/^\# Savannah include start/ .. /^\# Savannah include end/);
	print OUT $_;
    }
    close(IN); 

    seek(TEMP, 0, 0);
    while(<TEMP>) {
	print OUT $_;
    }

    close(OUT);
    print "$tmpdir/aliases written\n" if $debug;

    # Overwrite current system aliases with the new file
    unless ($debug) {
	move("$tmpdir/aliases", $sysaliases)
	    or die "Unable to overwrite $sysaliases with $tmpdir/aliases, exiting";
	system("/usr/bin/newaliases") if -e "/usr/bin/newaliases";
    } else {
	print "Would do \"/bin/mv $tmpdir/aliases $sysaliases\"\n";
	print "Would run \"/usr/bin/newaliases\"\n" if -e "/usr/bin/newaliases";
    }

    

}


# remove tmp directory
system("/bin/rm", "-rf", $tmpdir) 
    unless $debug;

# END

