#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_backup.pl,v 1.9 2005/06/30 16:33:51 toddy Exp $
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001, 2002
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use strict "refs";
use Getopt::Long;
use Savane;

# imports (needed for strict)
our $sys_miscdir;
our $sys_dbname;
our $sys_dbuser;
our $sys_dbpasswd;
our $sys_cron_mail;

# Preconfigure
my $getopt;
my $debug; 
my $help;
my $update;
my $recreate;
my $question_count = 0;
my $handle = STDOUT;
my $http_user;


my $prefix = $sys_miscdir;
my $verbose = 0;
my $user = $sys_dbuser;
my $password = $sys_dbpasswd;
my $getopt;
my $help;
my $fake;

eval {
    $getopt = GetOptions("verbose+" => \$verbose,
			 "user=s" => \$user,
			 "password=s" => \$password,
			 "fake" => \$fake,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
usage: $0 [--user=<user> --password=<password>] [--fake] [--help] [--verbose]

        Dump the sourceforge database and rotate the dumps.
	Generate tarbals of the CVS trees for retrieval and backup
	    by project administrators.

	--user=<user>		MySQL user name
	--password=<password>	MySQL password for user
	--verbose		increase verbosity level
	--fake			don\'t do nothing
	--help			print this help

Author: loic\@gnu.org
EOF
 exit(1);
}

$verbose++ if($fake);

sub file_mtime {
    my($path) = @_;

    my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
                      $atime,$mtime,$ctime,$blksize,$blocks)
	= stat($path);

    return $mtime;
}

#
# Return true if $a is newer than $b
#
sub file_newer {
    my($a, $b) = @_;

    return file_mtime($a) > file_mtime($b);
}

$user = "--user=$user" if($user);
$password = "--password=$password" if($password);

my($dir) = "$prefix/dumps";
chdir($dir) or die "cannot chdir $dir : $!";

system("logrotate --state logrotate.status logrotate.conf") if(!$fake);
system("mysqldump $user $password $sys_dbname > $sys_dbname.dump") if(!$fake);
system("chmod go-rw *.dump*") if(!$fake);


#
# Slurp savannah database related to group type
#
my(@projecttypes);
my(%projecttypes2info);

open(LIST, "mysql $user $password -Ne \"SELECT type_id,name,is_homepage_on_cvs, homepage_dir,can_use_cvs,cvs_dir,can_use_download,download_dir FROM group_type
\" $sys_dbname |") or die "mysql $user $password failed";
while(<LIST>) {
    chop;
    my($type_id, $name, $is_homepage_on_cvs, $homepage_dir, $can_use_cvs, $cvs_dir, $can_use_download, $download_dir) = split("\t", $_);
    push(@projecttypes, $type_id);
    $projecttypes2info{$type_id} = {
	'name' => $name,
	'is_homepage_on_cvs' => $is_homepage_on_cvs,
	'homepage_dir' => $homepage_dir,
	'can_use_cvs' => $can_use_cvs,
	'cvs_dir' => $cvs_dir,
	'can_use_download' => $can_use_download,
	'download_dir' => $download_dir,
    }
}
close(LIST);

print STDERR "Project types are @projecttypes\n" if ($verbose);

#
# Remember saved cvs trees
#
my(%cvs_dir_seen);

#
# Build backup files
#
foreach my $type (@projecttypes) {
    $dir = $projecttypes2info{$type}{'cvs_dir'};
    next if($dir eq '/' || exists($cvs_dir_seen{$dir}));
    $cvs_dir_seen{$dir} = 'yes';
    chdir($dir) or die "cannot chdir $dir : $!";

    my($backup_dir) = $dir."backups";

    my(%projects);
    my($tree);
    opendir(DIR, ".") or die "cannot opendir $dir : $!";
    while($tree = readdir(DIR)) {
	next if($tree eq '.' || $tree eq '..' || $tree eq 'CVSROOT' || $tree eq 'backups' || $tree eq 'common');
	$projects{$tree} = 1;
	my($tarbal) = "$backup_dir/$tree.tar.gz";
	my($needed);
	printf STDERR "\nShould we update $tarbal ?\n" if($verbose);
	if(! -f $tarbal) {
	    printf STDERR "There is no backup yet\n" if($verbose);
	    $needed = 1;
	}
	if(!defined($needed) && -f "$tree/CVSROOT/history") {
	    #
	    # History file my help us figure out if we need to backup
	    # the CVS tree
	    #
	    my($loghistory);
	    if(-f "$tree/CVSROOT/config") {
		($loghistory) = grep(/^\s*LogHistory/, `cat $tree/CVSROOT/config`);
		#
		#
		#	T	"Tag" cmd.
		#	O	"Checkout" cmd.
		#   E       "Export" cmd.
		#	F	"Release" cmd.
		#	W	"Update" cmd - No User file, Remove from Entries file.
		#	U	"Update" cmd - File was checked out over User file.
		#	G	"Update" cmd - File was merged successfully.
		#	C	"Update" cmd - File was merged and shows overlaps.
		#	M	"Commit" cmd - "Modified" file.
		#	A	"Commit" cmd - "Added" file.
		#	R	"Commit" cmd - "Removed" file.
		#
		if($loghistory) {
		    print STDERR $loghistory if($verbose > 1);
		    $loghistory =~ s/.=//;
		}
	    }
	    if($loghistory && $loghistory !~ /[OEFWUGC]/) {
		#
		# If read-only events are not logged, we can rely on its
		# modification time.
		#
		printf STDERR "history file only logs RW events, rely on history file modification time\n" if($verbose);
		$needed = file_newer("$tree/CVSROOT/history", $tarbal);
	    } else {
		#
		# Get the date of the last read-write event from the content
		# of the history file.
		#
		my($line) = `grep '^[TMAR]' $tree/CVSROOT/history | tail -1`;
		my($lastrw) = $line;
		if($lastrw) {
		    $lastrw = hex(substr($lastrw, 1, 8));
		    if($verbose > 1) {
			printf STDERR $line;
			printf STDERR "tarbal is dated " . localtime(file_mtime($tarbal)) . " and last history event " . localtime($lastrw) . "\n";
		    }
		    if($lastrw > file_mtime($tarbal)) {
			printf STDERR "last RW history event more recent than backup\n" if($verbose);
			$needed = 1;
		    } else {
			printf STDERR "last RW history event tells us we don't need to backup\n" if($verbose);
			$needed = 0;
		    }
		} else {
		    #
		    # No last RW event, cannot say nothing, maybe history
		    # file was reset by hand or something
		    #
		    ;
		}
	    }
	}
	
	if(!defined($needed)) {
	    #
	    # Do it the hard way : walk the tree until we find a file
	    # that is more recent than the backup.
	    #
	    system("find $tree -newer $tarbal -print | while read file ; do exit 1 ; done");
	    $needed = $? != 0;
	    print STDERR "the tree " . ($needed ? "" : "DOES NOT ") . "contain a file newer than the backup\n" if($verbose);
	}
	
	die "needed MUST be set at this stage" if(!defined($needed));
	
	if($needed) {
	    #
	    # Do the tar as ftpcvs so that non public files are not saved.
	    #
	    my($cmd) = "su ftpcvs -c 'tar -zhcf $tarbal $tree' 2>/dev/null";
	    print STDERR "$cmd\n" if($verbose);
	    system($cmd) if(!$fake);
	}
    }
    closedir(DIR);
    
#
# Remove backup files that do not belong to any projects
#
    my($file);
    opendir(DIR, $backup_dir) or die "cannot opendir $backup_dir : $!";
    while($file = readdir(DIR)) {
	next if(-d $file);
	next if(!($file =~ /(.*).tar.gz/));
	my($base) = $1;
	if(!exists($projects{$base})) {
	    my($backup) = "$backup_dir/$file";
	    print STDERR "rm $backup\n" if($verbose);
	    unlink($backup) if(!$fake);
	}
    }
    closedir(DIR);
    

}
