<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: userperms.php,v 1.35 2005/09/14 18:33:45 toddy Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--gnu.org>
#
#  Copyright 2004-2005 (c) Mathieu Roy <yeupou--gnu.org>
#                          Yves Perrin <yves.perrin--cern.ch>
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


require "../../include/pre.php";

session_require(array('group'=>$group_id,'admin_flags'=>'A'));

if ($update)
{
  # ##### Update members permissions

  $res_dev = db_query("select user_id FROM user_group WHERE group_id=$group_id AND admin_flags<>'P'");
  while ($row_dev = db_fetch_array($res_dev))
    {
      # site admins are not allowed to changer their own user rights
      # on a project they are member of.
      # It creates issues (flags erroneously set).
      # They should use admin interface instead or end su session
      if (user_is_super_user() && $row_dev['user_id'] == user_getid())
	{
	  fb(sprintf(_("Configuration for user #%s (you!) ignored to avoid incoherent flags status. End the superuser session to change your settings in this group or use the admin user interface."), $row_dev['user_id']), 1);
	  continue;
	}


      # admin are not allowed to turn off their own admin flag
      # it is too dangerous -- set it back to 'A'
      $admin_flags="admin_user_$row_dev[user_id]";
      if (user_getid() == $row_dev['user_id'])
	{
	  $$admin_flags='A';
	}

      # If someone is made admin, he got automatically the right to read
      # private items
      $privacy_flags="privacy_user_$row_dev[user_id]";
      if ($$admin_flags == "A")
	{ $$privacy_flags='1'; }

      $bugs_flags="bugs_user_$row_dev[user_id]";
      $task_flags="task_user_$row_dev[user_id]";
      $patch_flags="patch_user_$row_dev[user_id]";
      $support_flags="support_user_$row_dev[user_id]";
      $news_flags="news_user_$row_dev[user_id]";

      $sql = 'UPDATE user_group SET '
	 ."admin_flags='".$$admin_flags."',"
	 ."privacy_flags='".$$privacy_flags."',"
	 ."bugs_flags=".$$bugs_flags.","
	 ."news_flags=".$$news_flags.","
	 ."task_flags=".$$task_flags.", "
	 ."patch_flags=".$$patch_flags.", "
	 ."support_flags=".$$support_flags." "
	 ."WHERE user_id='$row_dev[user_id]' AND group_id='$group_id'";

      $result = db_query($sql);
      $name = user_getname($row_dev['user_id']);

      if ($result)
	{
	  group_add_history('Changed User Permissions',
			    $name,
			    $group_id);
	  $feedback_able .= $name.", ";
	}
      else
	{
	  print db_error();
	  $feedback_unable .= $name.", ";
	}
    }

  if ($feedback_able)
    {
      fb(sprintf(_("permissions for %s updated."), rtrim($feedback_able, ', ')));

    }

  if ($feedback_unable)
    {
      fb(sprintf(_("failed to update %s permissions."), rtrim($feedback_unable, ', ')),1);
    }


  # ##### Update group default permissions

  $bugs_flags="bugs_user_";
  $task_flags="task_user_";
  $patch_flags="patch_user_";
  $support_flags="support_user_";
  $news_flags="news_user_";

  # If the group entry do not exists, create it
  if (!db_result(db_query("SELECT groups_default_permissions_id FROM groups_default_permissions WHERE group_id='$group_id'"), 0, "groups_default_permissions_id"))
    {
      db_query("INSERT INTO groups_default_permissions (group_id) VALUES ($group_id)");
    }

  # Update the table
  $sql = 'UPDATE groups_default_permissions SET '
     ."bugs_flags=".$$bugs_flags.","
     ."news_flags=".$$news_flags.","
     ."task_flags=".$$task_flags.", "
     ."patch_flags=".$$patch_flags.", "
     ."support_flags=".$$support_flags." "
     ."WHERE group_id='$group_id'";

  $result = db_query($sql);

  if ($result)
    {
      group_add_history('Changed Group Default Permissions','',$group_id);
      fb(_("Permissions for the group updated."));

    }
  else
    {
      fb(_("Unable to change group defaults permissions."), 1);
    }

  # ##### Update posting restrictions
  # (if equal to 0, manually set to NULL, since 0 have a different meaning)
  $newitem_restrict_event1 = "bugs_restrict_event1";
  $newitem_restrict_event2 = "bugs_restrict_event2";
  $bugs_flags = ($$newitem_restrict_event2)*100 + $$newitem_restrict_event1;
  if (!$bugs_flags)
    { $bugs_flags = 'NULL'; }

  $newitem_restrict_event1 = "task_restrict_event1";
  $newitem_restrict_event2 = "task_restrict_event2";
  $task_flags = ($$newitem_restrict_event2)*100 + $$newitem_restrict_event1;
  if (!$task_flags)
    { $task_flags = 'NULL'; }

  $newitem_restrict_event1 = "support_restrict_event1";
  $newitem_restrict_event2 = "support_restrict_event2";
  $support_flags = ($$newitem_restrict_event2)*100 + $$newitem_restrict_event1;
  if (!$support_flags)
    { $support_flags = 'NULL'; }

  $newitem_restrict_event1 = "patch_restrict_event1";
  $newitem_restrict_event2 = "patch_restrict_event2";
  $patch_flags = ($$newitem_restrict_event2)*100 + $$newitem_restrict_event1;
  if (!$patch_flags)
    { $patch_flags = 'NULL'; }

  $news_flags="news_restrict_event1";

  # Update the table
  $sql = 'UPDATE groups_default_permissions SET '
     ."bugs_rflags=".$bugs_flags.","
     ."news_rflags=".$$news_flags.","
     ."task_rflags=".$task_flags.", "
     ."patch_rflags=".$patch_flags.", "
     ."support_rflags=".$support_flags." "
     ."WHERE group_id='$group_id'";

  $result = db_query($sql);

  if ($result)
    {
      group_add_history('Changed Posting Restrictions','',$group_id);
      fb(_("Posting restrictions updated."));

    }
  else
    {
      fb(_("Unable to change posting restrictions."), 1);
    }


}



# start HTML
site_project_header(array('title'=>_("Permissions Management"),'group'=>$group_id,'toptab'=>'ahome'));


$sql = "select user.user_name AS user_name,"
. "user.realname AS realname, "
. "user.user_id AS user_id, "
. "user_group.admin_flags, "
. "user_group.privacy_flags, "
. "user_group.bugs_flags, "
. "user_group.forum_flags, "
. "user_group.task_flags, "
. "user_group.patch_flags, "
. "user_group.news_flags, "
. "user_group.support_flags "
. "FROM user,user_group WHERE "
. "user.user_id=user_group.user_id AND user_group.group_id=$group_id AND user_group.admin_flags<>'P'"
. "ORDER BY user.user_name";

$result = db_query($sql);

print '<form action="'.$PHP_SELF.'" method="post">
<input type="hidden" name="group" value="'.$group_name.'">';

########################### POSTING RESTRICTIONS
# Exists also in trackers config (missing for news).

  $title_arr=array();
  $title_arr[]=_("Applies when ...");
  $title_arr[]=_("Support Tracker");
  $title_arr[]=_("Bug Tracker");
  $title_arr[]=_("Task Tracker");
  $title_arr[]=_("Patch Tracker");
  $title_arr[]=_("News");

  print '<h3>'._("Group trackers posting restrictions").'</h3>';

  print '<p>';
  print _("Here you can set the minimal authentification level required in order to post on the trackers.");
  print '</p>';

  print html_build_list_table_top ($title_arr);

  $i++;
  print '
  <tr class="'. utils_get_alt_row_color($i) .'">
    <td>'._("Posting new items").'</td>';
  html_select_restriction_box("support", group_getrestrictions($group_id, "support"));
  html_select_restriction_box("bugs", group_getrestrictions($group_id, "bugs"));
  html_select_restriction_box("task", group_getrestrictions($group_id, "task"));
  html_select_restriction_box("patch", group_getrestrictions($group_id, "patch"));
  html_select_restriction_box("news", group_getrestrictions($group_id, "news"));
  print '  </tr>';

  $i++;
  print '
  <tr class="'. utils_get_alt_row_color($i) .'">
    <td>'._("Posting comments").'</td>';
  html_select_restriction_box("support", group_getrestrictions($group_id, "support", 2),'', '', 2);
  html_select_restriction_box("bugs", group_getrestrictions($group_id, "bugs", 2),'', '', 2);
  html_select_restriction_box("task", group_getrestrictions($group_id, "task", 2),'', '', 2);
  html_select_restriction_box("patch", group_getrestrictions($group_id, "patch", 2),'', '', 2);
# not yet effective!
  print '<td align="center">---</td>';
#  html_select_restriction_box("news", group_getrestrictions($group_id, "news", 2),'', '', 2);
  print '  </tr>';

  print '
</table>
<p align="center"><input type="submit" name="update" value="'._("Update Permissions").'"></p>';


########################### GROUP DEFAULTS

$title_arr=array();
$title_arr[]=_("Support Tracker");
$title_arr[]=_("Bug Tracker");
$title_arr[]=_("Task Tracker");
$title_arr[]=_("Patch Tracker");
$title_arr[]=_("News");

print '<h3>'._("Group Default Permissions").'</h3>';
member_explain_roles();
print html_build_list_table_top ($title_arr);

html_select_permission_box("support", group_getpermissions($group_id, "support"), "group");
html_select_permission_box("bugs", group_getpermissions($group_id, "bugs"), "group");
html_select_permission_box("task", group_getpermissions($group_id, "task"), "group");
html_select_permission_box("patch", group_getpermissions($group_id, "patch"), "group");
html_select_permission_box("news", group_getpermissions($group_id, "news"), "group");


print '  </tr>
</table>
<p align="center"><input type="submit" name="update" value="'._("Update Permissions").'"></p>';


########################### PER MEMBERS

if (!$result || db_numrows($result) < 1)
{
  print '<h3>'._("No Members Found").'</h3>';
}
else
{
  # If we have more than 15 users, do not print list with selectboxes,
  # it does not scale, the page would be too big.

  print '<p>&nbsp;</p>';

  $title_arr=array();
  $title_arr[]=_("Member");
  $title_arr[]=_("General Rights");
  $title_arr[]=_("Support Tracker");
  $title_arr[]=_("Bug Tracker");
  $title_arr[]=_("Task Tracker");
  $title_arr[]=_("Patch Tracker");
  $title_arr[]=_("News");


  print '<h3>'._("Permissions per member").'</h3>';
  print '<p class="warn">';
  print _("Projects Admins are always allowed to read private items.");
  print '</p>';

  print html_build_list_table_top ($title_arr);

  # a function for this specific stuff that do not require generalization

  while ($row = db_fetch_array($result))
   {
     $i++;
     $reprinttitle++;
     if ($reprinttitle == 9)
       {
	 print html_build_list_table_top($title_arr, 0, 0);
	 $reprinttitle = 0;
       }
     print '
  <tr class="'. utils_get_alt_row_color($i) .'">
    <td align="center">'.utils_user_link($row['user_name'], $row['realname']).'</td>';
	 print '
    <td class="smaller">';
     if ($row['user_id'] == user_getid())
       {
	 print '<i>'._("You are Admin").'</i>';
       }
     else
       {
	 print '
      <input type="checkbox" name="admin_user_'.$row['user_id'].'" value="A" '.(($row['admin_flags']=='A')?'checked="checked"':'').' />&nbsp;'._("Admin");
       }
     if ($row['admin_flags'] != 'A')
       {
	 print '<br />
      <input type="checkbox" name="privacy_user_'.$row['user_id'].'" value="1" '.(($row['privacy_flags']=='1')?'checked="checked"':'').' />&nbsp;'._("Private Items");
       }
     else
       {
	 print form_input("hidden", 'privacy_user_'.$row['user_id'], 1);
       }
     print '
    </td>';


     html_select_permission_box("support", $row);
     html_select_permission_box("bugs", $row);
     html_select_permission_box("task", $row);
     html_select_permission_box("patch", $row);
     html_select_permission_box("news", $row);

     print '  </tr>';

   }

  print '
</table>
<p align="center"><input type="submit" name="update" value="'._("Update Permissions").'"></p></form>';


}


project_admin_footer(array());
?>
