<?php
print "<html>\n";
print "<head>\n";
print "	<title>Basic PHP tests</title>\n";
print "</head>\n";
print "<body>\n";


print "<h1>Basic PHP pre-tests for Savane installation</h1>\n";
print "<p>This page should help you to check whether your installation is properly configured. Once your installation is running, you should however probably removed it, or restrict its access, since it could give up to anybody details bout your setup.</p>";

#==============================================================================
print "<h2>Base PHP configuration:</h2>\n";

$phptags = array (
	'register_globals' => 1,
	'register_long_arrays' => 1,
	'file_uploads' => 1,
	'magic_quotes_gpc' => 1,
	'post_max_size' => '2M',
	'upload_max_filesize' => '2M',
	'arg_separator.output' => '&amp;',
);

print "<table border=\"1\">\n";
print "<tr><th>PHP Tag name</th><th>Local value</th><th>Suggested/Required value</th></tr>\n";
unset($unset);
ksort($phptags);
foreach ( $phptags as $tag => $goodval ) {
  if (htmlentities(ini_get($tag)) == htmlentities($goodval)) 
    {
      # OK
      printf ("<tr><td>%s</td><td>%s</td><td>%s</td></tr>\n",$tag,htmlentities(ini_get($tag)),htmlentities($goodval));
    }
  else if (htmlentities(ini_get($tag)))
    {
      # Different  
      printf ("<tr><td>%s</td><td bgcolor=\"#ffadad\"><font color=\"black\">%s</font></td><td>%s</td></tr>\n",$tag,htmlentities(ini_get($tag)),htmlentities($goodval));
    }
  else
    {
      # Non existing ini value: may be unset or Off 
      printf ("<tr><td>%s</td><td bgcolor=\"#ffdada\"><font color=\"black\">Off or Unset *</font></td><td>%s</td></tr>\n",$tag,htmlentities($goodval));
      $unset = 1;
    }
}
print "</table>\n";
if ($unset)
{
  print "<blockquote>* This tag was set to Off or not found at all. Look for this tag in php.ini. If you find it, update it accordingly. Otherwise, if you cannot find such tag in your php.ini file, it is probably irrelevant to your PHP installation and then should ignore this entry.</blockquote>";
}

#==============================================================================
print "<h2>PHP functions:</h2>\n";

$phpfunctions = array (
	'mysql_connect' => 'You should install/configure php-mysql ! [REQUIRED]',
	'gettext' => 'You should install/configure php with gettext support ! [RECOMMANDED]',
);

foreach ( $phpfunctions as $func => $comment ) {

	if (function_exists($func)) {
		print "function <b>".$func."()</b> exist.<br />\n";
	} else {
		print "function <b>".$func."()</b> does not exist. $comment <br />\n";
	}
}

#==============================================================================
print "<h2>Apache environnement vars:</h2>\n";

$configfile = '/etc/savannah/';

if ( getenv('SAVANE_CONF') ) {
	$configfile = getenv('SAVANE_CONF');
	print "SAVANE_CONF configured to ".$configfile."<br />\n";
} elseif ( getenv('SV_LOCAL_INC_PREFIX') ) {
	$configfile = getenv('SV_LOCAL_INC_PREFIX');
	print "SV_LOCAL_INC_PREFIX configured to ".$configfile."<br />\n";
} else {
	print "SAVANE_CONF nor SV_LOCAL_INC_PREFIX are set! (Default to ".$configfile.") <br />\n";
}

$configfile .= '/savannah.conf.php';

if (is_readable($configfile)) {
   print "File <b>$configfile</b> exists and is readable.";
} else {
   print "File <b>$configfile</b> does not exist or is not readable!";
}

#==============================================================================
print "<h2>Savane configuration:</h2>\n";

if (!is_readable($configfile)) 
{
  print "Since $configfile does not exist or is not readable, this part cannot be checked.";
}
else
{
  include $configfile;
  $variables = array (
	# Name  / required
		      'sys_default_domain' => 1,
		      'sys_https_host' => 0,
		      'sys_dbhost' => 1,
		      'sys_dbname' => 1,
		      'sys_dbuser' => 1,
		      'sys_dbpasswd' => 1,
		      'sys_www_topdir' => 1,
		      'sys_url_topdir' => 1,
		      'sys_incdir' => 1,
		      'sys_name' => 1,
		      'sys_unix_group_name' => 1,
		      'sys_themedefault' => 1,
		      'sys_mail_domain' => 1,
		      'sys_mail_admin' => 1,
		      'sys_mail_replyto' => 1,
		      );
  
  print "<table border=\"1\">\n";
  print "<tr><th>Conf variable</th><th>Current value</th><th>Is required?</th></tr>\n";
  unset($unset);
  foreach ( $variables as $tag => $required ) {
    if (!$required || htmlentities($GLOBALS[$tag]))
      {
        # Is set
	$value = $GLOBALS[$tag];
	if ($tag == "sys_dbpasswd")
	  { $value = "**************"; }
	
	printf ("<tr><td>%s</td><td>%s</td><td>%s</td></tr>\n",$tag,htmlentities($value),$required);
      }
    else
      {
        # Is not set, and should be set  
	printf ("<tr><td>%s</td><td bgcolor=\"#ffadad\"><font color=\"black\">%s</font></td><td>%s</td></tr>\n",$tag," ",$required);
      }
  }
  
  print "</table>\n";
}


#=============================================================================
print "<h2>Securing PHP configuration:</h2>\n";

print "The following is not required to run Savane but could enhance security of your production server. Some of these makes harder to debug an installation and, as such, should be avoided on a test installation, or if your installation is not working.";

$phptags = array (
	'display_errors' => 'Off',
	'allow_url_fopen' => 'Off',
	'disable_functions' => 'exec, passthru, popen, shell_exec, system',
);

print "<table border=\"1\">\n";
print "<tr><th>PHP Tag name</th><th>Local value</th><th>Suggested/Required value</th></tr>\n";
unset($unset);
ksort($phptags);
foreach ( $phptags as $tag => $goodval ) {
  if (htmlentities(ini_get($tag)) == htmlentities($goodval)) 
    {
      # OK
      printf ("<tr><td>%s</td><td>%s</td><td>%s</td></tr>\n",$tag,htmlentities(ini_get($tag)),htmlentities($goodval));
    }
  else if (htmlentities(ini_get($tag)))
    {
      # Different  
      printf ("<tr><td>%s</td><td bgcolor=\"#ffadad\"><font color=\"black\">%s</font></td><td>%s</td></tr>\n",$tag,htmlentities(ini_get($tag)),htmlentities($goodval));
    }
  else
    {
      # Non existing ini value: may be unset or Off 
      printf ("<tr><td>%s</td><td bgcolor=\"#ffdada\"><font color=\"black\">Off or Unset *</font></td><td>%s</td></tr>\n",$tag,htmlentities($goodval));
      $unset = 1;
    }
}
print "</table>\n";
if ($unset)
{
  print "<blockquote>* This tag was set to Off or not found at all. Look for this tag in php.ini. If you find it, update it accordingly. Otherwise, if you cannot find such tag in your php.ini file, it is probably irrelevant to your PHP installation and then should ignore this entry.</blockquote>";
}


#==============================================================================

print "<h2>That's it!</h2>";
print "</body>\n<html>\n";

?>