#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.pl 4566 2005-06-30 16:57:48Z toddy $
#
# Copyright (c) 2004-2005 Mathieu Roy <yeupou--gnu.org>
# http://yeupou.coleumes.org
#
#   The Savane project is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   The Savane project is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with the Savane project; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#

#
# Will reimplement a basic authentication + cookie stuff, to allow/disallow
# access to the lists.

use strict;
use warnings;
use CGI qw(:standard Link);
use CGI::Carp qw(fatalsToBrowser);
use Savane;

our $sys_unix_group_name;
my $client_session = cookie("session_hash");

# Check if a session exists on the client side
if ($client_session) {
    # Check if the session exits on the server side
    my @server_session = GetDBSettings("session", "session_hash='$client_session'");
    if (@server_session) {
	# Check which file is wanted, grant access if the user is member
	# of the group;
	my $user_id = $server_session[0];
	# The second part of the request url must be a valid list name
	my $list_name = $1 if $ENV{REQUEST_URI} =~ /^\/private\/([A-Za-z1-9-]+)\/.*$/;
	
	if ($list_name) 
	{
	    print header() && die "Unable to find a valid list name, exiting" 
		unless $list_name;
	    
	    my $group_id = GetDBSettings("mail_group_list", 
					 "list_name='$list_name'", 
					 "group_id");
	    if ($group_id) { 
		# Check if the user belongs to that group, check if the user
		# is member of the admin group
		my $is_valid = GetDBSettings("user_group", 
					     "group_id='$group_id' AND user_id='$user_id' AND admin_flags<>'P'",
					     "user_group_id");
		unless ($is_valid) {
		    $is_valid = GetDBList("user_group", "group_id='".GetGroupSettings($sys_unix_group_name, "group_id")."' AND admin_flags='A'", "user_group_id");
		    
		}
		
		if ($is_valid) {
		    # We get here, security checks are ok, now we serve the 
		    # page.
		    my $file = $1 if $ENV{REQUEST_URI} =~ /^\/private\/$list_name\/(.*)$/;
		    print header() && die "Unacceptable characters found, exiting"
			if $file =~ /\.\./;
		    
		    # If the file is a directory (or do not exists), 
		    # assume that we want the index within.
		    if (-d "/var/www/private/$list_name/$file" || ! $file) {
			$file .= "index.html";
		    }
		    
		    # Try to open and print the file.
		    if (-r "/var/www/private/$list_name/$file") {
			open(FILE, "< /var/www/private/$list_name/$file")
			    or print header() && die "Unable to print the requested file, exiting";
			print header();
			while (<FILE>) {
			    print $_;
			}
			close(FILE);
			exit;
		    } else {
			# Not able to open the file
			print header(), start_html(-title => "404 Error"); 
			print p("Unable to open the requested file ($file).");
			print end_html();
		    }
		} else {
		    # Not member of the group
		    print header(), start_html(-title => "Unauthorized Access");
		    print p("Sorry, you have no access to that area.");    
		    print p("You are not member of the group.");
		    print end_html();
		}	
		
	    } else {
		# List name passed invalid, not found
		print header(), start_html(-title => "Unauthorized Access");
		print p("Sorry, you have no access to that area.");
		print p("No list exists with the name found in the url ($list_name).");
		print end_html();
	    } 
	} else {
	    # List name passed invalid, not found
	    print header(), start_html(-title => "Unauthorized Access");
	    print p("Sorry, you have no access to that area.");
	    print p("No list exists with the name found in the url ($list_name).");
	    print end_html();
	}
    } else {
	# Session invalid on server-side
	print header(), start_html(-title => "Unauthorized Access");
	print p("Sorry, you have no access to that area."); 
	print p("You must be logged-in at gna.org first.");
	print end_html();
    }

} else {
    # Session invalid on client-side
    print header(), start_html(-title => "Unauthorized Access");
    print p("Sorry, you have no access to that area.");
    print p("You must be logged-in at gna.org first.");
    print end_html();
    exit;
}

# EOF
