#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Mail.pm 5893 2006-09-20 17:36:10Z yeupou $
#
# Copyright 2004-2005 (c) Mathieu Roy <yeupou--gnu.org>
# 
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


##
## Desc: any subs related to mail sending.
## This module is not loaded by Savannah.pm
##

use strict "vars";
require Mail::Send;
require Exporter;

# Exports
our @ISA = qw(Exporter);
our @EXPORT = qw(MailSend );
our $version = 1;

# Fixme: for now, there's only very limited testing here, it should in the
# end looks like sendmail.php

# from, to, subject, message
# Note: don't forget to escape @, otherwise address will be treated as 
# list.
sub MailSend {
    my $msg = new Mail::Send;
        
    $msg->to($_[1]);
    $msg->subject($_[2]);
    if ($_[0] ne "") {
	$msg->add("From", $_[0]);	
    } else {
	$msg->add("From", GetConf("sys_mail_replyto"));
    }
	
    $msg->add("Cc", $_[4]) if $_[4];
    $msg->add("X-Savane-Server", GetConf("sys_default_domain"));
    $msg->add("User-Agent", "Savane::Mail.pm");

    my $fh = $msg->open;
    print $fh $_[3]."\n\n_______________________________________________
  Message sent via/by ".GetConf("sys_name")."
  http://".GetConf("sys_default_domain").GetConf("sys_url_topdir")."\n";
    $fh->close;
}

return 1;
## EOF
