#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Svn.pm 5540 2006-08-10 21:21:50Z toddy $
#
# Copyright 2005      (c) Timothee Besset <ttimo--ttimo.net>
# 
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

##
## Desc: any subs related to SVN.
## read-write access: through authenticated ssh, spawning svnserve
## anonymous read: through svnserve daemon on port 3690
##   by default, svnserve only lets read for anonymous, and read-write for authed
##   since the systems have no passwords for users (only ssh keys), one can't auth to the anonymous daemon

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(SvnMakeArea SvnMakeAreaAttic );
our $version = 1;

sub SvnMakeArea {
    # FIXME: are private project handled as expected here?
    my ($name,$dir_svn) = @_;
    my $warning = "";

    # %PROJECT is not mandatory, but if it is missing, it may well be 
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific 
    # project.
    unless ($dir_svn =~ s/\%PROJECT/$name/) {
	$warning = " (The string \%PROJECT was not found, there may be a group type serious misconfiguration)";
    }

    unless (-e $dir_svn) {
	# set the umask right
	my $bak_umask = umask();
	umask(0002);
	# fsfs repositories are the most stable and scalable. bdb just
	# doesn't cut it
	system("svnadmin", "create", "--fs-type", "fsfs", $dir_svn);
	# create the default repository layout
	system("svn", "mkdir", "-q", "-m \"default layout\"", "file://$dir_svn/trunk");	system("svn", "mkdir", "-q", "-m \"default layout\"", "file://$dir_svn/tags");
	system("svn", "mkdir", "-q", "-m \"default layout\"", "file://$dir_svn/branches");
	# group ownership
	# svnadmin is expected to set 'set user or group ID on execution (s)'
	# for group on directories
	system("chgrp", "-R", $name, $dir_svn);
	# We do not want hooks to be group-modifiable, that would mean giving
	# shell access
	system("chgrp", "-R", "root", "$dir_svn/hooks");
	umask($bak_umask);

	return " ".$dir_svn.$warning;	
    }
    return 0;
}



## Make a svn area at gn!elsewhere.
## Ask yeupou--gna.org before modifying this function
sub SvnMakeAreaAttic {
    # Run the default sequence
    my $ret = SvnMakeArea(@_);
    
    if ($ret) {
	my ($name,$dir_svn) = @_;

	$dir_svn =~ s/\%PROJECT/$name/;
	
	# hardcode svnmailer support
	open(FILE, "> $dir_svn/hooks/post-commit");
	print FILE "#!/usr/bin/perl
system(\"svn-mailer\", \"-d\$ARGV[0]\", \"-r\$ARGV[1]\", \"-f/etc/svn-mailer.conf\");
";
	close(FILE);
	system("chmod", "755", "$dir_svn/hooks", "$dir_svn/hooks/post-commit");
	return " ".$dir_svn;
    }

    return;
}
