;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

(defpackage :edu.unm.hpc.Scat.delete-node-bin
  (:nicknames :Scat.delete-node-bin)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :cl-cli
        :scat.lib
        ))

(in-package :edu.unm.hpc.scat.delete-node-bin)

(defvar *name* NIL)

(defvar *opts*
  (list
   (make-instance 'cli-opt
                  :name "help"
                  :arguments ()
                  :action
                  #'(lambda ()
                      (org.prewett.cl-cli::help *opts*)
                      (cl-user::quit))
                  :description "display this help text")
   (make-instance 'cli-opt
                  :name :default
                  :arguments '(name)
                  :action
                  #'(lambda (name)
                      (setf *name* name)))))

(defun toplevel ()
  (sb-sys:enable-interrupt sb-unix:SIGINT #'handle-ctrl-c)
  ;;; Error checking stuff
  (handler-case 
      (progn
        ;; read the config file
        (edu.unm.hpc.scat.lib::read-scat-config)
        ;; process the options
        (cl-cli::process-options *opts* (rest sb-ext:*posix-argv*)))
    (BAD-ARGS-FOR-FLAG (c)
      (progn
        (warn "Bad arguments given for flag: ~A expecting between ~A and ~A, given ~A" 
              (flag c) (minargs c) (maxargs c) (given c))
        (help *opts*)
        (cl-user::quit))))
  
  (delete-node *name*)
  (cl-user::quit))

