;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

(defpackage :edu.unm.hpc.Scat.listmac
  (:nicknames :Scat.listmac)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :cl-cli
        :Scat.Lib
        ))

(in-package :edu.unm.hpc.Scat.listmac)

(defvar *nodes* ())

(defvar *opts* 
  (list
   (make-instance 'cli-opt
                  :name "help"
                  :arguments ()
                  :action
                  #'(lambda ()
                      (org.prewett.cl-cli::help *opts*)
                      (cl-user::quit))
                  :description "display this help text")
   (make-instance 'cli-opt
                  :name :default
                  :arguments '(noderange)
                  :action
                  #'(lambda (noderange)
                      (setf *nodes* 
                            (Scat.Lib::expand-nodelist noderange))))))

(defun toplevel () 
  (sb-sys:enable-interrupt sb-unix:SIGINT #'handle-ctrl-c)
  
  (handler-case 
      (progn
        (read-scat-config)
        (cl-cli::process-options *opts* (rest sb-ext:*posix-argv*)))
    ;; conditions ... 
    (BAD-ARGS-FOR-FLAG (c)
      (progn
        (warn "Bad arguments given for flag: ~A expecting between ~A and ~A, given ~A" 
              (flag c) (minargs c) (maxargs c) (given c))
        (help *opts*)
        (cl-user::quit))))

  (let ((max (+ 5 (loop for node in *nodes* maximize (length node)))))
    (mapcar
     (lambda (node)
       (let ((mac (scat.lib::list-mac node)))
         (unless (equal "" mac)
           (format t "~A~VT~A~%" node max mac))))
     *nodes*))
  (cl-user::quit))
