;;;; S-expr Cluster Administration Toolkit (SCAT)
;;;; Copyright (C) 2007 James Earl Prewett

;;;; This program is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License
;;;; as published by the Free Software Foundation; either version 2
;;;; of the License, or (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program; if not, write to the Free Software
;;;; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

(defpackage :edu.unm.hpc.Scat.nodels
  (:nicknames :Scat.nodels)
  (:use :cl
        #+allegro :clos
        #+cmu :pcl
        #+sbcl :sb-mop
        #+lispworks :hcl
        :cl-user
        :cl-cli
        :Scat.Lib
        ))

(in-package :edu.unm.hpc.Scat.nodels)

(defvar *nodes* ())

(defvar *opts* 
  (list
   (make-instance 'cli-opt
                  :name "help"
                  :arguments ()
                  :action
                  #'(lambda ()
                      (org.prewett.cl-cli::help *opts*)
                      (cl-user::quit))
                  :description "display this help text")
   (make-instance 'cli-opt
                  :name :default
                  :arguments '(noderange)
                  :action
                  #'(lambda (noderange)
                      (setf *nodes* 
                            (Scat.Lib::expand-nodelist noderange))))))

(defun toplevel () 
  (sb-sys:enable-interrupt sb-unix:SIGINT #'handle-ctrl-c)
  (read-scat-config)
  (handler-case
      (cl-cli::process-options *opts* (rest sb-ext:*posix-argv*))
    (bad-args-for-flag (c)
      (format t "bad arguments given: ~A~%" c)
      (help *opts*)
      (cl-user::quit :unix-status 1)))
  (let* ((actual-nodes (Scat.lib::list-node-files))
         (ls-nodes *nodes*)
         (intersection (intersection actual-nodes ls-nodes :test #'equal)))
    (if (eql (length ls-nodes)
             (length intersection)) ; are all of the requested nodes there?
        (format t "~{~A~%~}" ls-nodes)
        (format t "~{~A~%~}" (sort intersection #'string< ))))
  (cl-user::quit))
