/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* background.h -- Functions to draw jobset backgrounds */

#ifndef _BACKGROUND_H
#define _BACKGROUND_H

#include <schedwi.h>
#include <lwc_linkedlist.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

/* Background mode */
enum background_type {
	SOLID_COLOR,
	VERTICAL_GRADIENT,
	HORIZONTAL_GRADIENT,
	WALLPAPER_UPPERLEFT,
	WALLPAPER_CENTERED,
	WALLPAPER_TILED,
	WALLPAPER_SCALED,
	WALLPAPER_STRETCHED
};
typedef enum background_type background_t;

struct jobset_background {
	background_t background_mode;
	GdkPixbuf *background_image;
	GdkColor background_gradient_color_primary;
	GdkColor background_gradient_color_secondary;
	GnomeCanvasItem *canvas_bg;
	gchar *jobset_id;
	void (*refresh_func)(void *);
	void *refresh_func_user_data;
};
typedef struct jobset_background jobset_background_t;

extern jobset_background_t *new_jobset_background OF((lwc_LL *hierarchy_list,
						const gchar *jobset_id,
						void (*refresh_func)(void *),
						void *refresh_func_user_data));
extern void destroy_jobset_background OF((jobset_background_t *ptr));
extern void jobset_background_draw OF((	jobset_background_t *ptr,
					GnomeCanvas *canvas,
					gint width, gint height));
extern void background_menu_properties OF((GtkMenuItem *item));
extern void background_menu_new_job OF((GtkMenuItem *item));
extern void background_menu_new_jobset OF((GtkMenuItem *item));
extern void background_menu_paste_job OF((GtkMenuItem *item));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* background.h */

/*-----------------============== End Of File ==============-----------------*/
