#include <schedwi.h>
/*
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
*/

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"


#include <hosts_cb.h>
#include <host_cb.h>
#include <certificate_cb.h>
#include <env_widget.h>
#include <env_window_cb.h>
#include <env_list_cb.h>
#include <calendar_list_cb.h>
#include <calendar_folder_cb.h>
#include <calendar_cal_cb.h>
#include <link.h>
#include <job_cb.h>
#include <navigator.h>
#include <main_cb.h>
#include <find_cb.h>
#include <schedwi_main.h>
#include <pref_cb.h>
#include <login_cb.h>
#include <druid_cb.h>
#include <background_cb.h>
#include <background.h>
#include <database_test_cb.h>


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (schedwi_main_quit () == FALSE) {
		schedwi_main_destroy ();
	}
}


void
on_cut1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_cut_activated (menuitem);
}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_copy_activated (menuitem);
}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_paste_activated (menuitem);
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_preferences_activated (menuitem);
}


void
on_about2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *about;
	about = create_about1 ();
	gtk_widget_show (about);
}


void
on_properties2_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_properties (menuitem);
}


void
on_button_host_edit_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_edit_clicked (button);
}


void
on_button_host_new_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_new_clicked (button);
}


void
on_button_host_delete_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_delete_clicked (button);
}


void
on_button_host_refresh_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_refresh_clicked (button);
}


void
on_okbutton_host_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	host_ok_clicked (button);
}


void
on_button_host_where_used_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	hosts_where_used_clicked (button);
}


void
on_okbutton_env_choose_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	env_widget_env_choose_clicked (button);
}


void
on_button_env_edit_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	env_edit_clicked (button);
}


void
on_button_env_new_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	env_new_clicked (button);
}


void
on_button_env_where_used_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	env_where_used_clicked (button);
}


void
on_button_env_delete_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	env_delete_clicked (button);
}


void
on_button_env_refresh_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	env_list_refresh_clicked (button);
}


void
on_button_env_new_var_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	env_var_add_clicked (button);
}


void
on_button_env_del_var_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	env_var_remove_clicked (button);
}


void
on_button_env_up_var_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	env_var_up_clicked (button);
}


void
on_button_env_down_var_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	env_var_down_clicked (button);
}


void
on_button_env_var_top_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	env_var_top_clicked (button);
}


void
on_button_env_var_bottom_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	env_var_bottom_clicked (button);
}


void
on_okbutton_env_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	env_ok_clicked (button);
}


void
on_show_hosts_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_show_hosts_activate (menuitem);
}


void
on_show_environments_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_show_environments_activate (menuitem);
}


void
on_show_calendars_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_show_calendars_activate (menuitem);
}


gboolean
on_application_main_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return schedwi_main_quit ();
}

void
on_button_certificate_save_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	certificate_save (button);
}


void
on_button_host_upload_certificate_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	host_upload_certificate_view_clicked (button);
}


void
on_button_host_view_certificate_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	host_view_certificate_view_clicked (button);
}


gboolean
on_dialog_cal_list_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return calendar_list_delete_event (widget);
}


void
on_button_cal_close_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_close_clicked (button);
}


void
on_button_cal_list_year_prev_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_year_prev_clicked (button);
}


void
on_button_cal_list_year_next_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_year_next_clicked (button);
}


void
on_button_cal_refresh_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_refresh_clicked (button);
}


void
on_button_cal_cut_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_cut_clicked (button);
}


void
on_button_cal_copy_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_copy_clicked (button);
}


void
on_button_cal_paste_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_paste_clicked (button);
}


void
on_button_cal_delete_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_delete_clicked (button);
}


gboolean
on_treeview_cal_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return calendar_on_treeview_cal_button_press_event (widget, event);
}


gboolean
on_treeview_cal_popup_menu             (GtkWidget       *widget,
                                        gpointer         user_data)
{
	return calendar_on_treeview_cal_popup_menu (widget);
}


void
on_host_list_edit_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	hosts_edit_menu (menuitem);
}


void
on_host_list_new_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	hosts_new_menu (menuitem);
}


void
on_host_list_references_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	hosts_where_used_menu (menuitem);
}


void
on_host_list_delete_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	hosts_delete_menu (menuitem);
}


void
on_env_list_edit_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	env_edit_menu (menuitem);
}


void
on_env_list_new_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	env_new_menu (menuitem);
}


void
on_env_list_references_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	env_where_used_menu (menuitem);
}


void
on_env_list_delete_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	env_delete_menu (menuitem);
}


gboolean
on_treeview_hosts_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return hosts_on_treeview_cal_button_press_event (widget, event);
}


gboolean
on_treeview_hosts_popup_menu           (GtkWidget       *widget,
                                        gpointer         user_data)
{
	return hosts_on_treeview_cal_popup_menu (widget);
}


gboolean
on_treeview_environments_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return env_on_treeview_cal_button_press_event (widget, event);
}


gboolean
on_treeview_environments_popup_menu    (GtkWidget       *widget,
                                        gpointer         user_data)
{
	return env_on_treeview_cal_popup_menu (widget);
}


void
on_cal_menu_edit_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_edit_menu (menuitem);
}


void
on_cal_menu_new_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_new_menu (menuitem);
}


void
on_cal_menu_cut_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_cut_menu (menuitem);
}


void
on_cal_menu_copy_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_copy_menu (menuitem);
}


void
on_cal_menu_paste_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_paste_menu (menuitem);
}


void
on_cal_menu_delete_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_delete_menu (menuitem);
}


void
on_cal_menu_references_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	calendar_list_where_used_menu (menuitem);
}


void
on_button_cal_new_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_new_clicked (button);
}


void
on_okbutton_cal_new_question_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	okbutton_cal_new_question_clicked (button);
}


void
on_okbutton_cal_folder_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	cal_folder_ok_clicked (button);
}


void
on_button_cal_edit_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_edit_clicked (button);
}


void
on_button_cal_year_prev_preview_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_year_prev_clicked (button);
}


void
on_button_cal_year_next_preview_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_year_next_clicked (button);
}


void
on_cancelbutton_cal_calendar_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_cancel_clicked (button);
}


void
on_okbutton_cal_calendar_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_ok_clicked (button);
}


gboolean
on_dialog_cal_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

	calendar_cal_delete_event (widget);
	return FALSE;
}


void
on_button_cal_copy_formula_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_cal_copy_formula_clicked (button);
}


void
on_button_cal_where_used_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_where_used_clicked (button);
}


gboolean
on_dialog_host_list_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return host_list_delete_event (widget);
}


void
on_button_host_list_close_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	host_list_close_clicked (button);
}


gboolean
on_dialog_env_list_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return env_list_delete_event (widget);
}


void
on_button_env_list_close_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	env_list_close_clicked (button);
}


void
on_location_bar_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	location_bar_activate (menuitem);
}


void
on_zoomin_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	zoomin_activate ();
}


void
on_zoomout_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	zoomout_activate ();
}


void
on_normal_size_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	normal_size_activate ();
}


void
on_status_bar_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	status_bar_activate (menuitem);
}


void
on_show_grid_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	show_grid_activate (menuitem);
}


void
on_snap_to_grid_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	snap_to_grid_activate (menuitem);
}


gboolean
on_eventbox_main_navigator_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return eventbox_main_navigator_button_press (widget, event);
}


void
on_button_main_zoom_out_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	zoomout_activate();
}


void
on_button_main_zoom_in_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	zoomin_activate ();
}


gboolean
on_canvas_main_scroll_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return canvas_main_scroll_event (widget, (GdkEventScroll *)event);
}


void
on_refresh_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	reload_activate (menuitem);
}


void
on_toolbutton_refresh_clicked          (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	reload_tool_activate (toolbutton);
}


void
on_entry_main_location_activate        (GtkEntry        *entry,
                                        gpointer         user_data)
{
	location_activate (entry);
}


void
on_button_find_select_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	find_select_clicked (button);
}


void
on_button_find_close_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	find_close_clicked (button);
}


void
on_entry_find_activate                 (GtkEntry        *entry,
                                        gpointer         user_data)
{
	find_entry_activate (entry);
}


void
on_button_find_find_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	find_button_clicked (button);
}


gboolean
on_dialog_find_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return find_delete_event (widget);
}


void
on_toolbutton_find_clicked             (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	main_on_find_clicked (toolbutton);
}


void
on_find_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_find_activated (menuitem);
}


void
on_delete1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_delete (menuitem);
}


void
on_entry_pref_database_server_changed  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_host_changed_cb (GTK_ENTRY (editable));
}


void
on_entry_pref_database_name_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_database_changed_cb (GTK_ENTRY (editable));
}


void
on_fileentry_database_socket_changed   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_socket_changed_cb (editable);
}


void
on_combobox_pref_grid_style_changed    (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	pref_grid_line_style_changed_cb (combobox);
}


void
on_colorbutton_pref_grid_color_color_set
                                        (GtkColorButton  *colorbutton,
                                        gpointer         user_data)
{
	pref_grid_color_set_cb (colorbutton);
}


void
on_spinbutton_pref_grid_width_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	pref_grid_width_changed_cb (spinbutton);
}


void
on_spinbutton_pref_grid_height_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	pref_grid_height_changed_cb (spinbutton);
}


void
on_spinbutton_pref_cal_num_month_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	pref_calendar_months_by_row_changed_cb (spinbutton);
}


void
on_combobox_pref_cal_first_day_changed (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	pref_calendar_first_day_of_week_changed_cb (combobox);
}


void
on_fontbutton_pref_cal_font_font_set   (GtkFontButton   *fontbutton,
                                        gpointer         user_data)
{
	pref_calendar_font_set_cb (fontbutton);
}


void
on_radiobutton_pref_cal_font_theme_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	pref_calendar_use_system_font_toggled_cb (togglebutton);
}


gboolean
on_dialog_preferences_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	return pref_delete_event (widget);
}


void
on_closebutton_pref_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_close_clicked (button);
}


void
on_entry_pref_database_username_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	pref_database_user_changed_cb (GTK_ENTRY (editable));
}


void
on_spinbutton_pref_database_port_value_changed
                                        (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	pref_database_port_changed_cb (spinbutton);
}


void
on_button_pref_database_revert_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_database_restore_activated_cb (button);
}


void
on_button_pref_database_test_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_database_test_clicked_cb (button);
}


void
on_button_database_test_connect_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	database_test_go_clicked (button);
}


void
on_database_assistant_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	database_assistant_activate (menuitem);
}


void
on_login1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	login_activate (menuitem);
}


void
on_logout1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	logout_activate (menuitem);
}


void
on_button_login_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	login_clicked (button);
}


void
on_button_druid_connect_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	druid_test_database_clicked (button);
}


void
on_druidpagefinish1_finish             (GnomeDruidPage  *gnomedruidpage,
                                        GtkWidget       *widget,
                                        gpointer         user_data)
{
	druid_finish_clicked (gnomedruidpage, widget);
}


void
on_button_pref_grid_ratio_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	pref_grid_ratio_clicked (button);
}


void
on_okbutton_bg_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	background_cb_ok (button);
}


void
on_checkbutton_bg_hierarchy_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	background_cb_toggled (togglebutton);
}


void
on_spinbutton_bg_height_value_changed  (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	background_cb_height_changed_cb (spinbutton);
}


void
on_spinbutton_bg_width_value_changed   (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
	background_cb_width_changed_cb (spinbutton);
}


void
on_button_bg_ratio_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	background_cb_size_ratio_clicked (button);
}


void
on_button_bg_delete_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	background_cb_delete_clicked (button);
}


void
on_button_bg_upload_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	background_cb_upload_clicked (button);
}


void
on_button_bg_save_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	background_cb_save_clicked (button);
}


void
on_background_new_job_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	background_menu_new_job (menuitem);
}


void
on_background_new_jobset_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	background_menu_new_jobset (menuitem);
}


void
on_background_change_canvas_properties_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	background_menu_properties (menuitem);
}


void
on_checkbutton_job_h_host_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_host_toggled (togglebutton);
}


void
on_checkbutton_job_h_time_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_time_toggled (togglebutton);

}


void
on_checkbutton_job_h_start_limit_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_start_limit_toggled (togglebutton);

}


void
on_checkbutton_job_h_max_duration_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_max_duration_toggled (togglebutton);

}


void
on_checkbutton_job_h_calendar_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_calendar_toggled (togglebutton);
}


void
on_button_job_arg_new_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_arg_add_clicked (button);
}


void
on_button_job_arg_del_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_arg_del_clicked (button);
}


void
on_button_job_arg_up_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_arg_up_clicked (button);
}


void
on_button_job_arg_down_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_arg_down_clicked (button);
}


void
on_button_job_arg_top_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_arg_top_clicked (button);
}


void
on_button_job_arg_bottom_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_arg_bottom_clicked (button);
}


void
on_checkbutton_job_h_arg_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_arg_toggled (togglebutton);
}


void
on_checkbutton_job_h_command_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_command_toggled (togglebutton);
}


void
on_checkbutton_job_h_stdout_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_stdout_toggled (togglebutton);
}


void
on_checkbutton_job_h_stderr_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_stderr_toggled (togglebutton);
}


void
on_checkbutton_job_h_ret_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_ret_code_toggled (togglebutton);
}


void
on_checkbutton_job_h_username_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_username_toggled (togglebutton);
}


void
on_checkbutton_job_h_loadenv_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_loadenv_toggled (togglebutton);
}


void
on_checkbutton_job_env_loadparent_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_env_toggled (togglebutton);
}


void
on_button_job_file_add_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_constraint_file_add_clicked (button);
}


void
on_button_job_file_remove_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_constraint_file_del_clicked (button);
}

void
on_dialog_env_choose_destroy_event     (GtkObject       *object,
                                        gpointer         user_data)
{
        env_widget_env_choose_destroy (object);
}

void
on_checkbutton_job_icon_h_default_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_job_icon_default (togglebutton);
}


void
on_checkbutton_job_icon_h_waiting_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_job_icon_waiting (togglebutton);
}


void
on_checkbutton_job_icon_h_running_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_job_icon_running (togglebutton);
}


void
on_checkbutton_job_icon_h_completed_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_job_icon_completed (togglebutton);
}


void
on_checkbutton_job_icon_h_failed_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	job_cb_h_job_icon_failed (togglebutton);
}


void
on_button_job_icon_default_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_save_default (button);
}


void
on_button_job_icon_waiting_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_save_waiting (button);
}


void
on_button_job_icon_running_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_save_running (button);
}


void
on_button_job_icon_completed_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_save_completed (button);
}


void
on_button_job_icon_failed_save_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_save_failed (button);
}


void
on_button_job_icon_default_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_upload_default (button);
}


void
on_button_job_icon_waiting_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_upload_waiting (button);
}


void
on_button_job_icon_running_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_upload_running (button);
}


void
on_button_job_icon_completed_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_upload_completed (button);
}


void
on_button_job_icon_failed_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_icon_upload_failed (button);
}


void
on_checkbutton_jobset_icon_h_default_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	jobset_cb_h_jobset_icon_default (togglebutton);
}


void
on_checkbutton_jobset_icon_h_waiting_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	jobset_cb_h_jobset_icon_waiting (togglebutton);
}


void
on_checkbutton_jobset_icon_h_running_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	jobset_cb_h_jobset_icon_running (togglebutton);
}


void
on_checkbutton_jobset_icon_h_completed_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	jobset_cb_h_jobset_icon_completed (togglebutton);
}


void
on_checkbutton_jobset_icon_h_failed_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	jobset_cb_h_jobset_icon_failed (togglebutton);
}


void
on_button_jobset_icon_default_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_save_default (button);
}


void
on_button_jobset_icon_waiting_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_save_waiting (button);
}


void
on_button_jobset_icon_running_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_save_running (button);
}


void
on_button_jobset_icon_completed_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_save_completed (button);
}


void
on_button_jobset_icon_failed_save_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_save_failed (button);
}


void
on_button_jobset_icon_default_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_upload_default (button);
}


void
on_button_jobset_icon_waiting_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_upload_waiting (button);
}


void
on_button_jobset_icon_running_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_upload_running (button);
}


void
on_button_jobset_icon_completed_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_upload_completed (button);
}


void
on_button_jobset_icon_failed_upload_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	jobset_cb_icon_upload_failed (button);
}


void
on_button_job_calendar_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_calendar_choose (button);
}


void
on_button_cal_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	calendar_list_ok_clicked (button);
}


void
on_okbutton_job_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	job_cb_ok_clicked (button);
}


void
on_default_job_parameters1_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	job_cb_on_default_parameters_activated (menuitem);

}


void
on_completed1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_failed1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_running1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_waiting1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_statistics1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_statistics (menuitem);
}


void
on_completed2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	link_menu_change_completed (menuitem);
}


void
on_failed2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	link_menu_change_failed (menuitem);
}


void
on_running2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	link_menu_change_running (menuitem);
}


void
on_waiting2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	link_menu_change_waiting (menuitem);
}


void
on_delete2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	link_menu_delete (menuitem);
}

void
on_toolbutton_delete_clicked           (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	main_on_delete_clicked (toolbutton);
}


void
on_delete3_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	main_on_delete_activated (menuitem);
}


void
on_toolbutton_cut_clicked              (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	main_on_cut_clicked (toolbutton);
}


void
on_toolbutton_copy_clicked             (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	main_on_copy_clicked (toolbutton);
}


void
on_toolbutton_paste_clicked            (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
	main_on_paste_clicked (toolbutton);
}


void
on_cut2_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_cut (menuitem);
}


void
on_copy2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	child_job_menu_copy (menuitem);
}


void
on_background_paste_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	background_menu_paste_job (menuitem);
}

