/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* child_job.h -- Structure to draw a job/jobset on a GnomeCanvas */

#ifndef _CHILD_JOB_H
#define _CHILD_JOB_H

struct child_job;
typedef struct child_job child_job_t;


#include <schedwi.h>
#include <gtk/gtk.h>
#include <libgnomecanvas/libgnomecanvas.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <link.h>
#include <jobset_item.h>
#include <job_status_state.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct child_job {
	gchar *id;			/* Job/jobset ID */
	gchar *name;			/* Name (without path) */
	gchar type;			/* Type (0:jobset 1:job) */
	jobset_item_t *parent_jobset;	/* Pointer to the parent jobset */ 

	gdouble x, y, radius;
	gint width, height;
	gboolean selected;
	job_status_state state;

	/* `root' group under which the job/jobset will be drawn */
	GnomeCanvasGroup *canvas_group;
	/* Job/jobset name item */
	GnomeCanvasItem *canvas_name;
	/* Background rectangle below the name item when job/jobset selected */
	GnomeCanvasItem *canvas_name_bg;
	GnomeCanvasItem *canvas_name_bg_left;
	GnomeCanvasItem *canvas_name_bg_right;
	/* Icon */
	GnomeCanvasItem *canvas_icon;

	GdkPixbuf *icon[NUM_JOB_STATUS_STATE][NUM_HIGHLIGHT_MODES];

	/* Links connected with this job/jobset */
	GSList *links_out;
	GSList *links_in;
};


extern void destroy_child_job OF((child_job_t *ptr));
extern void destroy_child_job_list OF((GSList *list));
extern child_job_t * new_child_job OF((
		const gchar *id, const gchar *name, gchar type,
		gdouble x, gdouble y,
		jobset_item_t *parent_jobset));
extern GSList *get_child_job_list OF((	const gchar *parent_id,
					jobset_item_t *parent_jobset));
extern gchar *get_child_job_list_ids OF((GSList *list));
extern void child_job_add_link_out OF((child_job_t *ptr, link_t *link));
extern void child_job_add_link_in OF((child_job_t *ptr, link_t *link));
extern child_job_t *child_job_find OF((GSList *jobs, const gchar *id));
extern void child_job_draw OF((	child_job_t *ptr, GnomeCanvasGroup *group));
extern void child_job_select OF((child_job_t *ptr));
extern void child_job_unselect OF((child_job_t *ptr));
extern void child_job_draw_list OF((GSList *list, GnomeCanvasGroup *group));
extern void child_job_menu_statistics OF((GtkMenuItem *item));
extern void child_job_menu_properties OF((GtkMenuItem *item));
extern void child_job_menu_delete OF((GtkMenuItem *item));
extern gboolean child_job_delete OF((child_job_t *ptr));
extern void child_job_menu_cut OF((GtkMenuItem *item));
extern gboolean child_job_cut OF((child_job_t *ptr));
extern void child_job_menu_copy OF((GtkMenuItem *item));
extern gboolean child_job_copy OF((child_job_t *ptr));


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* child_job.h */

/*-----------------============== End Of File ==============-----------------*/
