/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* job_cb.h -- GUI functions for the job/jobset window */

#ifndef _JOB_CB_H
#define _JOB_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_job OF((
			const gchar *id, const gchar *name, gchar type,
			gdouble x, gdouble y, const gchar *parent_id,
			void (*reload)(void *, const gchar *),
			void *reload_data));
extern void job_cb_h_host_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_h_time_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_h_calendar_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_h_arg_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_arg_add_clicked OF((GtkButton *button));
extern void job_cb_arg_del_clicked OF((GtkButton *button));
extern void job_cb_arg_up_clicked OF((GtkButton *button));
extern void job_cb_arg_down_clicked OF((GtkButton *button));
extern void job_cb_arg_top_clicked OF((GtkButton *button));
extern void job_cb_arg_bottom_clicked OF((GtkButton *button));
extern void job_cb_h_entry_toggled OF((	GtkToggleButton *togglebutton,
					const gchar *widget_name));
extern void job_cb_h_spin_toggled OF((	GtkToggleButton *togglebutton,
					const gchar *widget_name));
extern void job_cb_h_username_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_h_loadenv_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_h_env_toggled OF((GtkToggleButton *togglebutton));
extern void job_cb_constraint_file_del_clicked OF((GtkButton *button));
extern void job_cb_constraint_file_add_clicked OF((GtkButton *button));
extern void job_cb_h_icon_toggled OF((	GtkToggleButton *togglebutton,
					const gchar *image_name,
					const gchar *button_save,
					const gchar *button_upload));
extern void job_cb_icon_save OF((GtkButton *button, const gchar *image_name));
extern void job_cb_icon_upload OF((GtkButton *button, const gchar *image_name));
extern void job_cb_calendar_choose OF((GtkButton *button));
extern void job_cb_on_default_parameters_activated OF((GtkMenuItem *menuitem));
extern void job_cb_ok_clicked OF((GtkButton *button));

#define job_cb_h_command_toggled(w) (job_cb_h_entry_toggled(w,"entry_job_command"))
#define job_cb_h_stdout_toggled(w) (job_cb_h_entry_toggled(w,"entry_job_stdout"))
#define job_cb_h_stderr_toggled(w) (job_cb_h_entry_toggled(w,"entry_job_stderr"))
#define job_cb_h_username_toggled(w) (job_cb_h_entry_toggled(w,"entry_job_username"))
#define job_cb_h_ret_code_toggled(w) (job_cb_h_spin_toggled(w,"spinbutton_job_ret"))
#define job_cb_h_max_duration_toggled(w) (job_cb_h_spin_toggled(w,"spinbutton_job_max_duration"))
#define job_cb_h_start_limit_toggled(w) (job_cb_h_spin_toggled(w,"spinbutton_job_start_limit"))

#define job_cb_h_job_icon_default(w) (job_cb_h_icon_toggled(w,"image_job_default","button_job_icon_default_save","button_job_icon_default_upload"))
#define job_cb_h_job_icon_waiting(w) (job_cb_h_icon_toggled(w,"image_job_waiting","button_job_icon_waiting_save","button_job_icon_waiting_upload"))
#define job_cb_h_job_icon_running(w) (job_cb_h_icon_toggled(w,"image_job_running","button_job_icon_running_save","button_job_icon_running_upload"))
#define job_cb_h_job_icon_completed(w) (job_cb_h_icon_toggled(w,"image_job_completed","button_job_icon_completed_save","button_job_icon_completed_upload"))
#define job_cb_h_job_icon_failed(w) (job_cb_h_icon_toggled(w,"image_job_failed","button_job_icon_failed_save","button_job_icon_failed_upload"))

#define job_cb_icon_save_default(w) (job_cb_icon_save(w,"image_job_default"))
#define job_cb_icon_save_waiting(w) (job_cb_icon_save(w,"image_job_waiting"))
#define job_cb_icon_save_running(w) (job_cb_icon_save(w,"image_job_running"))
#define job_cb_icon_save_completed(w) (job_cb_icon_save(w,"image_job_completed"))
#define job_cb_icon_save_failed(w) (job_cb_icon_save(w,"image_job_failed"))

#define job_cb_icon_upload_default(w) (job_cb_icon_upload(w,"image_job_default"))
#define job_cb_icon_upload_waiting(w) (job_cb_icon_upload(w,"image_job_waiting"))
#define job_cb_icon_upload_running(w) (job_cb_icon_upload(w,"image_job_running"))
#define job_cb_icon_upload_completed(w) (job_cb_icon_upload(w,"image_job_completed"))
#define job_cb_icon_upload_failed(w) (job_cb_icon_upload(w,"image_job_failed"))

#define jobset_cb_h_jobset_icon_default(w) (job_cb_h_icon_toggled(w,"image_jobset_default","button_jobset_icon_default_save","button_jobset_icon_default_upload"))
#define jobset_cb_h_jobset_icon_waiting(w) (job_cb_h_icon_toggled(w,"image_jobset_waiting","button_jobset_icon_waiting_save","button_jobset_icon_waiting_upload"))
#define jobset_cb_h_jobset_icon_running(w) (job_cb_h_icon_toggled(w,"image_jobset_running","button_jobset_icon_running_save","button_jobset_icon_running_upload"))
#define jobset_cb_h_jobset_icon_completed(w) (job_cb_h_icon_toggled(w,"image_jobset_completed","button_jobset_icon_completed_save","button_jobset_icon_completed_upload"))
#define jobset_cb_h_jobset_icon_failed(w) (job_cb_h_icon_toggled(w,"image_jobset_failed","button_jobset_icon_failed_save","button_jobset_icon_failed_upload"))

#define jobset_cb_icon_save_default(w) (job_cb_icon_save(w,"image_jobset_default"))
#define jobset_cb_icon_save_waiting(w) (job_cb_icon_save(w,"image_jobset_waiting"))
#define jobset_cb_icon_save_running(w) (job_cb_icon_save(w,"image_jobset_running"))
#define jobset_cb_icon_save_completed(w) (job_cb_icon_save(w,"image_jobset_completed"))
#define jobset_cb_icon_save_failed(w) (job_cb_icon_save(w,"image_jobset_failed"))

#define jobset_cb_icon_upload_default(w) (job_cb_icon_upload(w,"image_jobset_default"))
#define jobset_cb_icon_upload_waiting(w) (job_cb_icon_upload(w,"image_jobset_waiting"))
#define jobset_cb_icon_upload_running(w) (job_cb_icon_upload(w,"image_jobset_running"))
#define jobset_cb_icon_upload_completed(w) (job_cb_icon_upload(w,"image_jobset_completed"))
#define jobset_cb_icon_upload_failed(w) (job_cb_icon_upload(w,"image_jobset_failed"))

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_cb.h */

/*-----------------============== End Of File ==============-----------------*/
