/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_background.c -- jobset_background table management functions */

#include <schedwi.h>

#if STDC_HEADERS
#include <stdlib.h>
#else
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <sql_common.h>
#include <sql_background.h>


#define SQL_BACKGROUND_REPLACE "REPLACE into jobset_background (job_id,image,background_mode,gradient_color_primary,gradient_color_secondary,canvas_width,canvas_height) VALUES (\"%s\",\"%s\",%d,\"%s\",\"%s\",%d,%d)"


/*
 * Add/replace the background parameters
 *
 * Return:
 *     0 --> No error
 *     1 --> Memory allocation error (if error_func() is not NULL, it is called
 *           with user_data_error_func as its first parameter and the error
 *           message as the second parameter)
 * other --> SQL error (if error_func() is not NULL, it is called with
 *           user_data_error_func as its first parameter and the error message
 *           as the second parameter)
 */
unsigned int
sql_background_set (	const char *jobset_id,
			const char *image,
			unsigned long int image_len,
			int mode,
			const char *first_color,
			const char *last_color,
			int width, int height,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func)
{
	char *err_msg = NULL;
	unsigned int ret;

#if HAVE_ASSERT_H
	assert (   jobset_id != NULL
		&& first_color != NULL && last_color != NULL);
#endif

	ret = sql_non_select (	NULL, NULL, &err_msg, NULL, NULL,
				SQL_BACKGROUND_REPLACE,
				SQL_STRING, jobset_id,
				SQL_BIN, image, image_len,
				SQL_INT, (long int)mode,
				SQL_STRING, first_color,
				SQL_STRING, last_color,
				SQL_INT, (long int)width,
				SQL_INT, (long int)height,
				SQL_END);
	if (ret != 0) {
		if (error_func != NULL) {
			error_func (user_data_error_func, err_msg, ret);
		}
		if (err_msg != NULL) {
			free (err_msg);
		}
		return ret;
	}
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
