/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_background.h -- jobset_background table management functions */

#ifndef _SQL_BACKGROUND_H
#define _SQL_BACKGROUND_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int sql_background_set OF((
			const char *jobset_id,
			const char *image,
			unsigned long int image_len,
			int mode,
			const char *first_color,
			const char *last_color,
			int width, int height,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_background.h */

/*-----------------============== End Of File ==============-----------------*/
