/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_children_job.h -- functions to retrieve job details from the database */

#ifndef _SQL_CHILDREN_JOB_H
#define _SQL_CHILDREN_JOB_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_children_job_list OF((
                const char *parent_id,
                int (*add_row)( void * ,const char *, const char *,
                                const char *, const char *, const char *),
                void *user_data_add_row,
                void (*error_func)(void *, const char *, unsigned int),
                void *user_data_error_func));

extern unsigned int sql_children_get_icon OF((
			const char *id, const char *tablename,
                        char **icon_stream, unsigned long int *icon_stream_len,
                        void (*error_func)(void *, const char *, unsigned int),
                        void *user_data_error_func));
extern unsigned int sql_children_job_get_main OF((
			const char *id,
			void (*set_job_id)(const char *, void *),
			void (*set_job_parent)(const char *, void *),
			void (*set_job_name)(const char *, void *),
			void (*set_job_type)(const char *, void *),
			void (*set_job_enable)(const char *, void *),
			void (*set_job_descr)(const char *, void *),
			void (*set_job_x)(const char *, void *),
			void (*set_job_y)(const char *, void *),
			void (*set_job_calendar_id)(const char *, void *),
			void (*set_job_start_time)(const char *, void *),
			void *user_data_set_job,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_children_job_update_coord OF((
			const char *id,
			const char *x_str, const char *y_str,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_children_job_get_parameter OF((lwc_LL *lst,
                        const char *tablename,
                        const char *colname,
                        char **value, char **value_hist,
                        unsigned long int *value_len,
                        void (*error_func)(void *, const char *, unsigned int),
                        void *user_data_error_func));


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_children_job.h */

/*-----------------============== End Of File ==============-----------------*/
