/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* hosts_cb.h -- GUI functions for the hosts list window */

#ifndef _HOSTS_CB_H
#define _HOSTS_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_host_list
			OF((void (*hide_cb)(gpointer), gpointer user_data));
extern gboolean host_list_delete_event OF((GtkWidget *widget));
extern void host_list_close_clicked OF((GtkButton *button));
extern void hosts_refresh OF((GtkTreeView *view));
extern void hosts_refresh_clicked OF((GtkButton *button));
extern void hosts_refresh_widget OF((GtkWidget *widget));
extern void hosts_edit_clicked OF((GtkButton *button));
extern void hosts_where_used_clicked OF((GtkButton *button));
extern void hosts_edit_menu OF((GtkMenuItem *item));
extern void hosts_where_used_menu OF((GtkMenuItem *item));
extern gboolean hosts_on_treeview_cal_button_press_event OF((
						GtkWidget *treeview,
						GdkEventButton *event));
extern gboolean hosts_on_treeview_cal_popup_menu OF((GtkWidget *treeview));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* hosts_cb.h */

/*-----------------============== End Of File ==============-----------------*/
