/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* job_select.h -- Job and link selection management */

#ifndef _JOB_SELECT_H
#define _JOB_SELECT_H

struct job_select;
typedef struct job_select job_select_t;

#include <schedwi.h>
#include <link.h>
#include <child_job.h>
#include <glib.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

enum item_type {
	JOB_SELECT_TYPE_JOB,
	JOB_SELECT_TYPE_LINK
};
typedef enum item_type item_type_t;

struct job_select {
	item_type_t item_type;
	union {
		link_t *link;
		child_job_t *job;
	} item;
	gboolean set;
};


extern job_select_t *new_job_select OF(());
extern void destroy_job_select OF((job_select_t *ptr));
extern void job_select_job OF((	job_select_t *ptr, child_job_t *job,
				gboolean select_item));
extern void job_select_link OF((job_select_t *ptr,
				link_t *link, gboolean select_item));
extern void job_select_unselect OF((job_select_t *ptr));
extern void job_select_unselect_all OF((job_select_t *ptr, gboolean redraw));
extern gboolean job_select_is_job_selected OF((	job_select_t *ptr,
						child_job_t *job));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_select.h */

/*-----------------============== End Of File ==============-----------------*/
