/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* navigator.h -- GUI functions for the navigation window */

#ifndef _NAVIGATOR_H
#define _NAVIGATOR_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif


struct navigator {
	GtkWidget *w;
	GnomeCanvas *canvas;
	GnomeCanvasItem *selection;
	gdouble ratio;
	gint width, height;
	gint selection_width, selection_height;
	gdouble selection_x, selection_y;
	GnomeCanvas *real_canvas;
};
typedef struct navigator navigator_t;

extern gboolean eventbox_main_navigator_button_press OF((GtkWidget *widget,
						GdkEventButton *event));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* navigator.h */

/*-----------------============== End Of File ==============-----------------*/
