/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* schedwi_main.h -- Global functions */

#ifndef _SCHEDWI_MAIN_H
#define _SCHEDWI_MAIN_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern void store_application_main OF((GtkWidget *w));
extern void main_activate OF(());
extern void main_deactivate OF(());
extern void main_on_show_hosts_activate OF((GtkMenuItem *menuitem));
extern void main_on_show_environments_activate OF((GtkMenuItem *menuitem));
extern void main_on_show_calendars_activate OF((GtkMenuItem *menuitem));
extern void main_on_find_clicked OF((GtkToolButton *button));
extern void main_on_find_activated OF((GtkMenuItem *menuitem));
extern void main_on_worload_date_changed OF((int workload_date));
extern void main_on_preferences_activated OF((GtkMenuItem *menuitem));
extern void main_copy_cut_set_sensitive OF((gboolean status));
extern void main_paste_set_sensitive OF((gboolean status));
extern void main_delete_set_sensitive OF((gboolean status));
extern void main_on_cut_clicked OF((GtkToolButton *button));
extern void main_on_cut_activated OF((GtkMenuItem *menuitem));
extern void main_on_copy_clicked OF((GtkToolButton *button));
extern void main_on_copy_activated OF((GtkMenuItem *menuitem));
extern void status_bar_activate OF((GtkMenuItem *menuitem));
extern void location_bar_activate OF((GtkMenuItem *menuitem));
extern void zoomin_activate OF(());
extern void zoomout_activate OF(());
extern void normal_size_activate OF(());
extern void show_grid_activate OF((GtkMenuItem *menuitem));
extern void snap_to_grid_activate OF((GtkMenuItem *menuitem));
extern gboolean show_grid_get_active OF(());
extern gboolean snap_to_grid_get_active OF(());
extern void reload_activate OF((GtkMenuItem *menuitem));
extern void reload_tool_activate OF((GtkToolButton *button));
extern void combobox_changed OF((GtkComboBox *combobox));
extern void location_activate OF((GtkEntry *entry));
extern gboolean schedwi_main_quit OF(());
extern void schedwi_main_destroy OF(());
extern void schedwi_main_login OF(());
extern void login_activate OF((GtkMenuItem *menuitem));
extern void logout_activate OF((GtkMenuItem *menuitem));
extern void database_assistant_activate OF((GtkMenuItem *menuitem));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* schedwi_main.h */

/*-----------------============== End Of File ==============-----------------*/
