/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* schedwi_time.h -- Time and date management functions */

#ifndef _SCHEDWI_TIME_H
#define _SCHEDWI_TIME_H

#include <schedwi.h>

#if HAVE_TIME_H
#include <time.h>
#endif
#if TM_IN_SYS_TIME
#include <sys/time.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef time_t schedwi_time;

struct _schedwi_date {
	unsigned short int year;
	unsigned char month;
	unsigned char day;
};
typedef struct _schedwi_date schedwi_date;

extern void schedwi_date_add_days OF((	schedwi_date in, schedwi_date *out,
					int nb));
extern schedwi_time schedwi_time_add_minutes OF((schedwi_time in, int nb));
#define schedwi_time_add_seconds(in,nb) ((in)+(nb))
#define schedwi_time_now() time(NULL)
extern schedwi_time schedwi_time_to_midnight OF(());
extern char *schedwi_time_strftime OF((const char *format, schedwi_time in));
extern schedwi_time schedwi_time_convert OF((schedwi_date in, int hour_min));
extern schedwi_time schedwi_time_convert_from_string OF((schedwi_date in,
					const char *str));
extern int schedwi_date_from_int OF((	unsigned int year_month_day,
					schedwi_date *out));
extern int schedwi_date_from_string OF((const char *data_str,
					schedwi_date *out));
extern char *schedwi_date_to_string OF((schedwi_date in));
extern int schedwi_date_to_int OF((schedwi_date in));
extern void schedwi_date_now OF((schedwi_date *out));
extern int schedwi_date_compar OF((	const schedwi_date *a,
					const schedwi_date *b));
extern char *schedwi_time_duration_to_str OF((unsigned long int nb_sec));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* schedwi_time.h */

/*-----------------============== End Of File ==============-----------------*/
