/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_link.h -- functions to retrieve link details from the database */

#ifndef _SQL_LINK_H
#define _SQL_LINK_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int sql_link_list OF((
		int workload_date,
		const char *id_list,
		int (*add_row)(	void *, const char *, const char *,
				const char *),
		void *user_data_add_row,
		void (*error_func)(void *, const char *, unsigned int),
		void *user_data_error_func));

extern unsigned int sql_link_get_list OF((
			int workload_date,
			lwc_LL **rows,
			const char *id_list,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

extern unsigned int sql_link_del OF((
			const char *job_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_link_del1 OF((
			const char *job_src, const char *job_dst,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_link_type OF((
			const char *job_src, const char *job_dst,
			long int new_type,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_link_add OF((
			const char *job_src, const char *job_dst,
			long int new_type,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_link.h */

/*-----------------============== End Of File ==============-----------------*/
