/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* net_module.h -- Manages module functions */

#ifndef _NET_MODULE_H
#define _NET_MODULE_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <net_utils_glob.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int (*net_module OF((const char *module_name)))
			OF((net_id *, char *, size_t));
extern int add_module OF((	const char *module_name,
				int (*module)(net_id *, char *, size_t)));
extern void destroy_modules OF(());
extern ssize_t build_module_name OF((const char *module_name, char **buffer));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_module.h */

/*-----------------============== End Of File ==============-----------------*/
