/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
   USA.
*/

/* net_utils_init.h -- Initialize the network (mainly for SSL) */

#ifndef _NET_UTILS_INIT_H
#define _NET_UTILS_INIT_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int net_init OF((const char *client_crt, const char *client_key,
			const char *server_crt));
extern int net_init_server OF(());
extern void net_free OF(());
extern char ssl_enabled OF(());

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_init.h */

/*-----------------============== End Of File ==============-----------------*/
