/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* parse_env_and_arg.h -- Parse an environement or an argument line */

#ifndef _PARSE_ENV_AND_ARG_H
#define _PARSE_ENV_AND_ARG_H

#include <schedwi.h>

#include <lwc_linkedlist.h>
#include <args_utils.h>
#include <env_utils.h>
#include <net_utils_glob.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int parse_arguments OF((net_id *sock, char *argument, lwc_LL *list));
extern int parse_environment OF((net_id *sock, char *environment_var,
				lwc_LL *list));
extern void destroy_argument_list OF((lwc_LL *list));
extern void destroy_environment_list OF((lwc_LL *list));
extern int argument_list_to_job_parameter OF((lwc_LL *list, argument_t *arg));
extern int environment_list_to_job_env OF((lwc_LL *list, environment_t *env));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* parse_env_and_arg.h */

/*-----------------============== End Of File ==============-----------------*/
