/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
   USA.
*/

/* net_utils.h -- Useful network functions */

#ifndef _NET_UTILS_H
#define _NET_UTILS_H

#include <schedwi.h>

#include <net_utils_sock.h>
#include <net_utils_ssl.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _schedwi_BIO {
	char use_ssl;
	int fd;
	gnutls_session_t session;
	gnutls_certificate_credentials_t *trusted_cert_ptr;
};
typedef struct _schedwi_BIO schedwi_BIO;

extern int net_init OF((const char *schedwisrv_crt_file,
			const char *schedwisrv_key_file));
extern int net_init_server OF(());
extern void net_destroy OF(());
extern int net_accept OF((	int sock,
				int (*run)(schedwi_BIO *, void *),
				void *user_data));
extern schedwi_BIO *net_client OF((const char *port_number,
			const char *hostname, char use_ssl,
			char *remote_crt, unsigned int remote_crt_len));
extern int net_read OF((schedwi_BIO *in, char **buff, unsigned int *len));
extern int net_read_result OF((schedwi_BIO *in, char **result_msg));
extern int net_write OF((schedwi_BIO *out, const char *buff, int len));
extern int net_write_eof OF((schedwi_BIO *out));
extern void net_close OF((schedwi_BIO *out));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils.h */

/*-----------------============== End Of File ==============-----------------*/
