/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* workload_class.h -- Functions to run a workload */

#ifndef _WORKLOAD_CLASS_H
#define _WORKLOAD_CLASS_H

#include <schedwi.h>

#include <pthread.h>

#include <calendar_list.h>
#include <schedwi_time.h>
#include <schedwi_jobtree_priv.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _workload_class {
	pthread_t thread;
	schedwi_date workload_date;
	jobtree_ptr jobtree;
};
typedef struct _workload_class workload_class;
typedef struct _workload_class *workload_class_ptr;

extern workload_class_ptr workload_class_new OF((schedwi_date workload_date,
					calendar_list_t_ptr calendars));
extern void workload_class_destroy OF((workload_class_ptr ptr));
extern int workload_class_date_compar OF((const schedwi_date *workload_date,
					const workload_class_ptr ptr));
extern int workload_class_is_completed OF((workload_class_ptr ptr));
extern int workload_class_job_finished OF((workload_class_ptr ptr,
					unsigned long long int id,
					job_status_state status,
					long int duration,
					const char *status_message));
extern void workload_class_print OF((workload_class_ptr ptr));
extern void workload_class_job_foreach OF((
				workload_class_ptr ptr,
				unsigned long long int id,
				int (*foreach_func)(schedwi_jobtree_node_ptr,
							void *),
				void *data_user));


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* workload_class.h */

/*-----------------============== End Of File ==============-----------------*/
