/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* sql_hosts.h -- hosts table management functions */

#ifndef _SQL_HOSTS_H
#define _SQL_HOSTS_H

#include <schedwi.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	ID = 0,
	HOSTNAME,
	PORTNUM,
	SSLENABLE,
	SSLCERT,
	DESCR
} host_columns;

extern int sql_hosts_list OF((
	int (*add_row)(void *, const char *, const char *, const char *),
	void *user_data_add_row,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));
extern unsigned int sql_host_delete OF((const char *host_id,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));
extern unsigned int sql_host_get_main OF((
	const char *host_id,
	void (*set_host_id)(const char *, void *),
	void (*set_host_name)(const char *, void *),
	void (*set_host_port)(const char *, void *),
	void (*set_host_SSL)(const char *, void *),
	void (*set_host_cert)(const char *, void *),
	void (*set_host_descr)(const char *, void *),
	void *user_data_set_host,
	void (*error_func)(void *, const char *, unsigned int),
	void *user_data_error_func));
extern unsigned int sql_host_get_main_row OF((
			const char *host_id,
			char ***row_out,
			unsigned long int **row_out_len,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_host_get_main_row_names OF((
			char **host_names,
			char ***row_out,
			unsigned long int **row_out_len,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_host_new OF((
			const char *hostname, const char *portnum,
			char sslenable, const char *sslcert,
			const char *description,
			unsigned long int *new_host_id,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_host_update OF((
			const char *host_id,
			const char *hostname, const char *portnum,
			char sslenable, const char *sslcert,
			const char *description,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_host_certificate OF((char **names,
			char *sslenable,
			char **certificate, unsigned long int *certificate_len,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));
extern unsigned int sql_host_replace OF((
			const char *hostname, const char *portnum,
			char sslenable, const char *sslcert,
			const char *description,
			void (*error_func)(void *, const char *, unsigned int),
			void *user_data_error_func));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_hosts.h */

/*-----------------============== End Of File ==============-----------------*/
