#!/bin/sh
### BEGIN INIT INFO
# Provides:          schedwiclnt
# Required-Start:    $syslog $remote_fs $local_fs $network $named
# Required-Stop:     $syslog $remote_fs $local_fs $network $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start the Schedwi agent daemon at boot time
# Description:       Schedwi is a task scheduler.  This script 
#                    starts the agent daemon, schedwiclnt.
### END INIT INFO

test -x "/usr/bin/schedwiclnt" || exit 0

case "$1" in
start)
       echo -n "Starting schedwi agent service: schedwiclnt"
       start-stop-daemon --start --quiet \
         --exec "/usr/bin/schedwiclnt"
       echo "."
       ;;
stop)
       echo -n "Stopping schedwi agent service: schedwiclnt"
       start-stop-daemon --stop --quiet  \
         --pidfile "/var/run/schedwiclnt.pid" \
         --exec "/usr/bin/schedwiclnt"
       echo "."
       ;;
restart)
       echo -n "Restarting schedwi agent service: schedwiclnt"
       start-stop-daemon --stop --quiet --oknodo \
         --pidfile "/var/run/schedwiclnt.pid" \
         --exec "/usr/bin/schedwiclnt"
       start-stop-daemon --start --verbose \
         --exec "/usr/bin/schedwiclnt"
       echo "."
       ;;
force-reload|reload)
       echo -n "Reloading configuration of schedwi agent service: schedwiclnt"
       start-stop-daemon --stop --signal 1 --quiet  \
         --pidfile "/var/run/schedwiclnt.pid" \
         --exec "/usr/bin/schedwiclnt"
       echo "."
       ;;
*)
       echo "Usage: /etc/init.d/schedwiclnt " \
              " {start|stop|restart|reload|force-reload}" >&2
       exit 1
       ;;
esac
     
exit 0
