/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * args_utils.h -- Arguments array management functions
 *
 * The argument array is an array of strings.  This array is embedded in the
 * argument_t structure but can be used directly by system functions like exec.
 */

#ifndef _ARGS_UTILS_H
#define _ARGS_UTILS_H

#include <schedwi.h>

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#elif HAVE_STDDEF_H
#include <stddef.h>
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct arg_str {
	char **arg;
	int length;
	int idx;
};

typedef struct arg_str argument_t;

extern void init_argument OF((argument_t *e));
extern void destroy_argument OF((argument_t *e));
extern int add_arg_s OF((argument_t *e, const char *val, size_t val_len));
extern int add_arg OF((argument_t *e, const char *val));
extern const char *getvar_argument OF((argument_t *e, int idx));
extern char *args_to_string OF((argument_t *e));
extern char *args_array_to_string OF((char **a));
extern int args_concat OF((argument_t *dst, argument_t *src));
extern void set_arg OF((argument_t *dst, argument_t *src));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* args_utils.h */

/*-----------------============== End Of File ==============-----------------*/
