/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * job_launcher.h -- Executing a job
 */

#ifndef _JOB_LAUNCHER_H
#define _JOB_LAUNCHER_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <job_parameters.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

#if HAVE_PID_T
extern int submit_job OF((	job_parameters_t *j, const char *job_id,
				pid_t *job_pid,
				char **err_msg));
#else
extern int submit_job OF((	job_parameters_t *j, const char *job_id,
				int *job_pid,
				char **err_msg));
#endif

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* job_launcher.h */

/*-----------------============== End Of File ==============-----------------*/
