/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* net_parse.c -- Parse and run a network request */

#include <schedwi.h>

#if STDC_HEADERS
#include <string.h>
#endif

#if HAVE_ERRNO_H
#include <errno.h>
#endif
#ifndef errno
extern int errno;
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <net_utils_glob.h>
#include <net_module.h>
#include <lwc_log.h>
#include <net_parse.h>

/*
 * Parse and run the network request
 * buff (and its lenght len) is a working buffer.  It is allocated by this
 * function if NULL and must be freed by the caller.
 *
 * Return:
 *    0 --> No error
 *   -1 --> Error (an error message is displayed by using lwc_writeLog())
 */
int
net_parse (net_id *sock, char **buff, size_t *len)
{
	ssize_t nb_read;
	char module[SCHEDWI_NET_FUNCTION_LENGHT + 1];
	int (*function)(net_id *, char *, size_t);

#if HAVE_ASSERT_H
	assert (sock != NULL && buff != NULL && len != NULL);
#endif

	nb_read = net_read (sock, buff, len);
	if (nb_read < 0) {
		return -1;
	}

	if (nb_read < SCHEDWI_NET_FUNCTION_LENGHT) {
		lwc_writeLog (LOG_ERR,
			_("Wrong network request: not enough characters"));
		return -1;
	}

	strncpy (module, *buff, SCHEDWI_NET_FUNCTION_LENGHT);
	module[SCHEDWI_NET_FUNCTION_LENGHT] = '\0';
	function = net_module (module);
	if (function == NULL) {
		lwc_writeLog (LOG_ERR,
			_("Wrong network request: unknown module `%s'"),
			module);
		return -1;
	}

	if (function (	sock,
			*buff + SCHEDWI_NET_FUNCTION_LENGHT,
			nb_read - SCHEDWI_NET_FUNCTION_LENGHT) != 0)
	{
		return -1;
	}
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
