/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* net_utils_init.c -- Initialize the network (mainly for SSL) */

#include <schedwi.h>

#if HAVE_LIBGNUTLS
#include <net_utils_ssl.h>
#endif

#if HAVE_ASSERT_H
#include <assert.h>
#endif

#include <conf.h>
#include <net_utils_init.h>

static char enable_ssl;


/*
 * Init the network subsystem
 * If SSL is used, the parameters are required
 *
 * Return:
 *   0 --> No error
 *  -1 --> Error (a message is displayed in stderr)
 */
int
net_init (	const char *client_crt, const char *client_key,
		const char *server_crt, char quick_random)
{
#if HAVE_LIBGNUTLS
	int ret;

	ret = conf_get_param_bool ("SSLEngine", &enable_ssl);
#if HAVE_ASSERT_H
	assert (ret == 0);
#endif
	if (enable_ssl != 0) {
		return net_init_ssl (	client_crt, client_key,
					server_crt, quick_random);
	}
#else
	enable_ssl = 0;
#endif
	return 0;
}


/*
 * Initialize the SSL network layer (for the server part)
 * This function is slow and can take several minutes to run
 *
 * Return:
 *   0 --> No error
 *  -1 --> Error (a message has been logged by lwc_writeLog())
 */
int
net_init_server ()
{
#if HAVE_LIBGNUTLS
	if (enable_ssl != 0) {
		return net_init_server_ssl ();
	}
#endif
	return 0;
}


/*
 * Destroy the SSL parameters
 */
void
net_free ()
{
#if HAVE_LIBGNUTLS
	if (enable_ssl != 0) {
		net_destroy_ssl ();
	}
#endif
}


/*
 * Should SSL be used?
 */
char
ssl_enabled ()
{
	return enable_ssl;
}

/*-----------------============== End Of File ==============-----------------*/
