/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* net_utils_ssl.h -- Useful network functions (socket connection with SSL) */

#if HAVE_LIBGNUTLS

#ifndef _NET_UTILS_SSL_H
#define _NET_UTILS_SSL_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <gnutls/gnutls.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int net_init_ssl OF((	const char *clnt_crt_file,
				const char *clnt_key_file,
				const char *server_crt,
				char quick_random));
extern int net_init_server_ssl OF(());
extern void net_destroy_ssl OF(());
extern int net_accept_ssl OF((	int fd, gnutls_session_t *session,
				const char *server_hostname));
extern int net_client_ssl OF((	int fd, gnutls_session_t *session,
				const char *server_hostname));
extern ssize_t net_read_ssl OF((gnutls_session_t session,
				char **buff, size_t *len));
extern int net_read_result_ssl OF((gnutls_session_t session, char **result_msg));
extern int net_write_ssl OF((	gnutls_session_t session,
				const char *buff, size_t len));
extern int net_write_eof_ssl OF((gnutls_session_t session));
extern int net_close_ssl OF((gnutls_session_t session, int fd));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_ssl.h */

#endif /* HAVE_LIBGNUTLS */

/*-----------------============== End Of File ==============-----------------*/
