/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * srvtest_testfile.c -- Test program for the Schedwi agent
 *
 * Parameters:
 *     1) The absolute path of an existing file
 *
 * Output:
 *     stdout) The result of the command execution send by the schedwiclnt
 *
 * Return:
 *   0 on success or
 *   an other return code for error
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#if HAVE_NETDB_H
#include <netdb.h>
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef HAVE_RECV
#define recv(a,b,c,d) read(a,b,c)
#endif

#ifndef HAVE_SEND
#define send(a,b,c,d) write(a,b,c)
#endif

#ifndef PF_INET
#define PF_INET AF_INET
#endif

#ifndef HAVE_CLOSESOCKET
#define closesocket(x) close(x)
#endif

/*
 * memset - fill memory with a constant byte
 */
void *
schedwi_memset (void *s, int c, unsigned int n)
{
        char *tmp = s;

        if (s != 0) {
                while (n/10 != 0) {
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        *(tmp++) = c;
                        n -= 10;
                }
                while (n > 0) {
                        *(tmp++) = c;
                        n--;
                }
        }
        return s;
}


/*
 * strlen - calculate the length of a string
 */
size_t
schedwi_strlen (const char *s)
{
	size_t i;

	if (s == NULL) {
		return 0;
	}
	for (i = 0; s[i] != '\0'; i++);
	return i;
}


/*
 * atoi - convert a string to an integer (very simplified version)
 */
int
schedwi_atoi (const char *s)
{
	size_t i;
	int val;

	if (s == NULL) {
		return 0;
	}

	while (*s != '\0' && (*s == ' ' || *s == '\t')) {
		s++;
	}

	val = 0;
	for (i = 0; s[i] != '\0' && s[i] >= '0' && s[i] <= '9'; i++) {
		val *= 10;
		val += s[i] - '0';
	}
	return val;
}


/*
 * Send a job request to the client
 */
int
send_testfile (const char *path_to_file)
{
	int sock;
	struct sockaddr_in sad;
	char buff[4096];
	char result;
	ssize_t nb_read;
	struct hostent *he;

	/* Get the address of the local host */
	he = gethostbyname ("127.0.0.1");
	if (he == NULL) {
		return 8;
	}

	/* Create the socket */
	sock = socket (PF_INET, SOCK_STREAM, 0);
	if (sock < 0) {
		return 9;
	}

	/* Compose the remote address */
	schedwi_memset (&sad, 0, sizeof(sad));
        sad.sin_family = AF_INET;
        sad.sin_addr.s_addr = *((unsigned long *)(he->h_addr_list[0]));
	sad.sin_port = htons (schedwi_atoi (SCHEDWI_DEFAULT_AGTPORT));

	/* Connect to the address */
	if (connect (sock, (struct sockaddr *)&sad, sizeof(sad)) != 0) {
		closesocket (sock);
		return 10;
	}

	/* Build and send the header */
	schedwi_memset (buff, 0, 25);
	buff[0] = 't';
	buff[1] = 'e';
	buff[2] = 's';
	buff[3] = 't';
	buff[4] = 'f';
	buff[5] = 'i';
	buff[6] = 'l';
	buff[7] = 'e';
	buff[8] = '-';
	buff[9] = '0';
	buff[10] = '.';
	buff[11] = '1';
	send (sock, buff, 25, 0);

	/* Send the file name to test */
	send (sock, "FIL:$FILE_NAME\n", 15, 0);

	/* Send the environment */
	send (sock, "ENV:1:A:1\n", 10, 0); 
	send (sock, "ENV:2:B:2\n", 10, 0); 
	send (sock, "ENV:3:C:foo\n", 12, 0); 
	send (sock, "ENV:4:CMD:$C\n", 13, 0); 
	send (sock, "ENV:5:FILE_NAME:", 16, 0); 
	send (sock, path_to_file, schedwi_strlen (path_to_file), 0);
	send (sock, "\n", 1, 0);

	send (sock, "\nbYe", 4, 0);

	/* Read the reply and dump it to stdout */
	result = 0;
	do{
		nb_read = recv (sock, buff, 4096, 0);
		if (nb_read == 0) {
			break;
		}
		if (nb_read < 0) {
			closesocket (sock);
			return 11;
		}
		if (result == 0) {
			result = buff[0];
		}
		write (1, buff, nb_read);
	} while (1);

	closesocket (sock);

	if (result != '0') {
		return 12;
	}
	return 0;
}


/*
 * Main function
 */
int
main (int argc, char **argv)
{
	char *path_to_file;

	if (argc != 2) {
		return 1;
	}
	path_to_file = argv[1];

	/*
	 * Send the test file request
	 */
	return send_testfile (path_to_file);
}

/*------------------------======= End Of File =======------------------------*/
