/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * net_utils_ssl.h -- Useful network SSL functions
 */

#ifndef _NET_UTILS_SSL_H
#define _NET_UTILS_SSL_H

#include <schedwi.h>

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <gnutls/gnutls.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int net_server_ssl OF((gnutls_session_t *session, int fd,
		gnutls_certificate_credentials_t *trusted_cert_ptr,
		char **names,
		char *remote_crt, unsigned long int remote_crt_len));
extern int net_init_server_ssl OF(());
extern void net_destroy_ssl OF(());
extern int net_init_ssl OF((	const char *schedwisrv_crt_file,
				const char *schedwisrv_key_file,
				char quick_random));
extern int net_client_ssl OF((const char *port_number, const char *hostname,
		gnutls_session_t *session, int *fd,
		gnutls_certificate_credentials_t *trusted_cert_ptr,
		char *remote_crt, unsigned int remote_crt_len));
extern ssize_t net_read_ssl OF((gnutls_session_t session,
				char **buff, unsigned int *len));
extern int net_write_ssl OF((	gnutls_session_t session,
				const char *buff, size_t len));
extern int net_close_ssl OF((	gnutls_session_t session, int fd,
			gnutls_certificate_credentials_t *trusted_cert_ptr));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* net_utils_ssl.h */

/*-----------------============== End Of File ==============-----------------*/
