/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* request.h -- Common functions to build a request to a client */

#ifndef _REQUEST_H
#define _REQUEST_H

#include <schedwi.h>
#include <startjob_request.h>
#include <lwc_linkedlist.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern int request_job_init OF((int workload_date,
				unsigned long long int job_id,
				char **host_id_out,
				startjob_request_ptr *request_out,
				lwc_LL **hierarchy_list_out));
extern int request_testfile_init OF((int workload_date,
				unsigned long long int job_id,
				const char *host_id_str,
				const char *filename,
				startjob_request_ptr *request_out));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* request.h */

/*-----------------============== End Of File ==============-----------------*/
