/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* schedwi_jobtree.h -- Function to access the job/jobset tree */

#ifndef _SCHEDWI_JOBTREE_H
#define _SCHEDWI_JOBTREE_H

#include <schedwi.h>

#include <schedwi_time.h>
#include <job_status_state.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

/* A required file structure */
struct _schedwi_jobtree_file {
	unsigned long long int host_id;
	char *file;
	char exist;
};
typedef struct _schedwi_jobtree_file schedwi_jobtree_file;
typedef struct _schedwi_jobtree_file *schedwi_jobtree_file_ptr;


struct _schedwi_jobtree_link;

/* A job/jobset node structure */
struct _schedwi_jobtree_node {
	struct _schedwi_jobtree_node *parent, *children;
	struct _schedwi_jobtree_node *next, *prev;

	unsigned long long int id;
	char *path;               /* Full job/jobset name (with its path) */
	schedwi_time run_time;    /* Start date and time of this job/jobset */
	schedwi_time start_time;  /* Real start time */

	/* Max number of seconds for this job/jobset to be started */
	long int start_limit;

	/* Max number of seconds for this job/jobset to complete */
	long int max_duration;

	/* Max number of retries if the job/jobset failed */
	int retries;

	/* Current retry number */
	int retry_num;

	/* Number of seconds between retries */
	long int retries_interval;

	/* Node type: 0 --> Jobset   1 --> Job */
	char node_type;

	/* Current status of the job/jobset */
	job_status_state status;

	/* Links list */
	struct _schedwi_jobtree_link *links;

	/* List of the links to this job/jobset */
	struct _schedwi_jobtree_link *links_in;

	/* Array of required files */
	schedwi_jobtree_file_ptr constraint_files;
	int num_constraint_files;
};
typedef struct _schedwi_jobtree_node schedwi_jobtree_node;
typedef struct _schedwi_jobtree_node *schedwi_jobtree_node_ptr;


/* A link structure */
struct _schedwi_jobtree_link {
	struct _schedwi_jobtree_link *next;
	struct _schedwi_jobtree_node *linked_node;
	job_status_state required_status;
};
typedef struct _schedwi_jobtree_link schedwi_jobtree_link;
typedef struct _schedwi_jobtree_link *schedwi_jobtree_link_ptr;


#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* schedwi_jobtree.h */

/*-----------------============== End Of File ==============-----------------*/
