/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* calendar_canvas.h -- GNOME Canvas displaying a calendar */

#ifndef _CALENDAR_CANVAS_H
#define _CALENDAR_CANVAS_H

#include <schedwi.h>
#include <gtk/gtk.h>
#include <calendar.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

enum calendar_canvas_mode {
	READONLY,
	READWRITE
};
typedef enum calendar_canvas_mode calendar_canvas_mode_t;

struct day_obj {
	GDate *d;		/* Date corresponding to this day object */
	struct calendar_canvas *self_calendar;
	gboolean selected;	/* Is the day selected? */
	GnomeCanvasItem *background;	/* Selection mark */
	GnomeCanvasItem *text;	/* Text */
};
typedef struct day_obj day_t;

struct month_obj {
	guchar month;
	struct calendar_canvas *self_calendar;
	GnomeCanvasGroup *month_group;
	GnomeCanvasItem *background;
	GnomeCanvasItem *text;
	day_t *days[31];
};
typedef struct month_obj month_t;


struct calendar_canvas {
	GnomeCanvas *canvas;		/* Associated GNOME Canvas */
	GnomeCanvasItem *background;	/* Background rectangle */
	GDateWeekday first_day_of_week;
	GDateYear year;
	gchar *font;			/* Font use for all the texts */

	GdkColor text_color_normal;
	GdkColor text_color_prelight;
	GdkColor text_color_selected;
	GdkColor base_color_normal;
	GdkColor base_color_prelight;
	GdkColor base_color_selected;

	gint num_month_by_row;		/* Number of months to display by row*/
	gdouble w, h, day_border;	/* Size of a day */
	calendar_canvas_mode_t mode;	/* READONLY or READWRITE */
	guint gconf_notify;		/* GConf notify function ID */
	gchar *current_calendar;	/* Calendar formula */
	guchar bit_selected_wday;	/* Bit field of selected week days */
	guint bit_selected_month;	/* Bit field of selected month */
	month_t *month_obj[12];

	/*
	 * Callbacks used when a day (or week day or month) is set/unset
	 * by the user clicking on a day (or week day or month)
	 */
	gboolean (*cb_set_day)(struct calendar_canvas *, GDateDay, GDateMonth, gpointer);
	gpointer cb_set_day_user_data;
	gboolean (*cb_unset_day)(struct calendar_canvas *, GDateDay, GDateMonth, gpointer);
	gpointer cb_unset_day_user_data;
	gboolean (*cb_set_wday)(struct calendar_canvas *, GDateWeekday, gpointer);
	gpointer cb_set_wday_user_data;
	gboolean (*cb_unset_wday)(struct calendar_canvas *, GDateWeekday, gpointer);
	gpointer cb_unset_wday_user_data;
	gboolean (*cb_set_month)(struct calendar_canvas *, GDateMonth, gpointer);
	gpointer cb_set_month_user_data;
	gboolean (*cb_unset_month)(struct calendar_canvas *, GDateMonth, gpointer);
	gpointer cb_unset_month_user_data;
};
typedef struct calendar_canvas calendar_canvas_t;


extern calendar_canvas_t *new_calendar_canvas OF((GnomeCanvas *canvas,
					calendar_canvas_mode_t mode));
extern void destroy_calendar_canvas OF((calendar_canvas_t *ptr));
extern void draw_year_canvas OF((calendar_canvas_t *ptr, GDateYear year));
extern cal_errcode_t set_calendar OF((	calendar_canvas_t *ptr,
					const gchar *calendar,
					int *error_idx_in_str));
extern void clear_calendar OF((calendar_canvas_t *ptr));

extern void set_callbacks_set_day OF((calendar_canvas_t *ptr,
	gboolean (*f)(calendar_canvas_t *, GDateDay, GDateMonth, gpointer),
	gpointer user_data));
extern void set_callbacks_unset_day OF((calendar_canvas_t *ptr,
	gboolean (*f)(calendar_canvas_t *, GDateDay, GDateMonth, gpointer),
	gpointer user_data));
extern void set_callbacks_set_wday OF((calendar_canvas_t *ptr,
	gboolean (*f)(calendar_canvas_t *, GDateWeekday, gpointer),
	gpointer user_data));
extern void set_callbacks_unset_wday OF((calendar_canvas_t *ptr,
	gboolean (*f)(calendar_canvas_t *, GDateWeekday, gpointer),
	gpointer user_data));
extern void set_callbacks_set_month OF((calendar_canvas_t *ptr,
	gboolean (*f)(calendar_canvas_t *, GDateMonth, gpointer),
	gpointer user_data));
extern void set_callbacks_unset_month OF((calendar_canvas_t *ptr,
	gboolean (*f)(calendar_canvas_t *, GDateMonth, gpointer),
	gpointer user_data));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* calendar_canvas.h */

/*-----------------============== End Of File ==============-----------------*/
