/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* calendar_list_cb.h -- GUI functions for the calendar list window */

#ifndef _CALENDAR_LIST_CB_H
#define _CALENDAR_LIST_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_calendar_list OF((	void (*hide_cb)(gpointer),
						gpointer user_data,
						int workload_date));
extern void dialog_calendar_list_set_workload_date OF((
			GtkWidget *dialog_cal_list, int workload_date));
extern void calendar_list_close_clicked OF((GtkButton *button));
extern void calendar_list_ok_clicked OF((GtkButton *button));
extern gboolean calendar_list_delete_event OF((GtkWidget *widget));
extern void calendar_list_year_prev_clicked OF((GtkButton *button));
extern void calendar_list_year_next_clicked OF((GtkButton *button));
extern void calendar_list_refresh OF((GtkTreeView *view));
extern void calendar_list_refresh_widget OF((GtkWidget *widget));
extern void calendar_list_refresh_clicked OF((GtkButton *button));
extern void calendar_list_edit_clicked OF((GtkButton *button));
extern void calendar_list_where_used_clicked OF((GtkButton *button));
extern gboolean calendar_on_treeview_cal_button_press_event OF((
						GtkWidget *treeview,
						GdkEventButton *event));
extern gboolean calendar_on_treeview_cal_popup_menu OF((GtkWidget *treeview));

extern void calendar_list_edit_menu OF((GtkMenuItem *item));
extern void calendar_list_where_used_menu OF((GtkMenuItem *item));
extern int calendar_list_build_model OF((	GtkTreeStore **model,
						int workload_date));
extern gboolean calendar_list_get_selected OF((	GtkWidget *dialog,
						gchar **id, gchar **path));
extern gchar *calendar_list_get_path OF((	GtkTreeStore *model,
						const gchar *id));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* calendar_list_cb.h */

/*-----------------============== End Of File ==============-----------------*/
