/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* commands.h -- commands management functions */

#ifndef _COMMANDS_H
#define _COMMANDS_H

#include <schedwi.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	COMMAND_UNKNOWN = 0,
        COMMAND_CHANGE_STATUS,
        COMMAND_STOP
} command_t;


extern int command_add OF((	int workload, const char *job_id,
				const char *username,
				command_t cmd, int parameter, char **err_msg));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* commands.h */

/*-----------------============== End Of File ==============-----------------*/
