/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* copy_paste.h - Job/jobset copy/cut/paste functions */

#ifndef _COPY_PASTE_H
#define _COPY_PASTE_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern void copy_paste_clear OF(());
extern void copy_paste_clear_if OF((const gchar *job_id));
extern void copy_paste_clear_if_cut OF(());
extern void copy_paste_clear_if_this_id_is_cut OF((const gchar *job_id));
extern gboolean copy_paste_is_this_id_cut OF((const gchar *job_id));
extern void copy_paste_cut OF((
			const gchar *job_id,
			void (*function_clear)(const gchar *, gpointer),
			gpointer user_data_clear,
			void (*function_paste)(	const gchar *,
						gdouble, gdouble, gpointer),
			gpointer user_data_paste));
extern void copy_paste_copy OF((
			const gchar *job_id,
			void (*function_clear)(const gchar *, gpointer),
			gpointer user_data_clear,
			void (*function_paste)(	const gchar *,
						gdouble, gdouble, gpointer),
			gpointer user_data_paste));
extern gboolean copy_paste_is_set OF(());

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* copy_paste.h */

/*-----------------============== End Of File ==============-----------------*/
