/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This file is part of Schedwi.

   Schedwi is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   Schedwi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* env_widget.h - Environment choice widget */

#ifndef _ENV_WIDGET_H
#define _ENV_WIDGET_H

#include <schedwi.h>
#include <gtk/gtk.h>
#include <lwc_linkedlist.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

struct _env_widget {
	GtkWidget *view;
	GtkWidget *button_add;
	gulong handler_button_add;
	GtkWidget *button_delete;
	gulong handler_button_delete;
	GtkWidget *button_up;
	gulong handler_button_up;
	GtkWidget *button_down;
	gulong handler_button_down;
	GtkWidget *button_top;
	gulong handler_button_top;
	GtkWidget *button_bottom;
	gulong handler_button_bottom;
};
typedef struct _env_widget env_widget;
typedef struct _env_widget *env_widget_ptr;

extern env_widget_ptr env_widget_new OF((GtkWidget *view,
					const gchar *button_add,
					const gchar *button_delete,
					const gchar *button_up,
					const gchar *button_down,
					const gchar *button_top,
					const gchar *button_bottom));
extern void env_widget_destroy OF((env_widget_ptr ptr));
extern void env_widget_build_rows OF((env_widget_ptr ptr, lwc_LL *values));
extern int env_widget_build_sql OF((
			env_widget_ptr ptr,
			const gchar *id,
			int workload_date,
			int (*sql_func)(
				int,
				const char *,
				lwc_LL **,
				void (*)(void *, const char *, unsigned int),
				void *)));
extern int env_widget_save_list OF((
			env_widget_ptr ptr,
			const gchar *id,
			int (*sql_func)(
				const char *,
				lwc_LL *,
				void (*)(void *, const char *, unsigned int),
				void *)));
extern env_widget_ptr env_widget_get_from_view OF((GtkWidget *view));

/* Environment choose dialog callbacks */
extern void env_widget_env_choose_clicked OF((GtkButton *button));
extern void env_widget_env_choose_destroy OF((GtkObject *dialog_choose)); 

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* env_widget.h */

/*-----------------============== End Of File ==============-----------------*/
